﻿function init_tags_events()
{
    // Up and down management for tag table lines
    $(".up,.down").click(function(){
        tag_up_down(this);
    });
    // Remove tag for a datasheet's list
    $(".remove_tag_from_list").click(function(){
        if(confirm("Confirmez-vous la suppression du tag \"" + $(this).attr('alt') + "\" de la liste courante ?")){
            remove_tag_from_list(this);
        }
    });
    //activate_wp_cb
    $(".activate_wp_cb").click(function(e){
        new_checked = $(this).is(':checked');
        if(new_checked){
            question = "Confirmez-vous l'activation du lien Wikipédia pour le tag \"" + $(this).attr('alt') + "\" ?";
        } else {
            question = "Confirmez-vous la désactivation du lien Wikipédia pour le tag \"" + $(this).attr('alt') + "\" ?";
        }
        if(confirm(question)){
            validate_wp_link(this);
        }
        else{
            // Since the click event is dispatched after the checked changed, we change the checked changed if confirm is false.
            e.preventDefault(); // unvalidates user's click
            $(this).attr('checked', !new_checked);
        }
    });
}

function validate_wp_link(cb)
{
    var url = validate_wp_link_url;
    var id_tag = $(cb).attr('id');
    new_checked = $(cb).is(':checked');
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token,
               datasheet_id:$('#datasheet_id').val(),
               tag_id:id_tag,
               activated:new_checked
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#tag_table_container').html(msg);
            init_tags_events();
        }
    });
}

function remove_tag_from_list(btn)
{
    var url = remove_tag_from_list_url;
    var id_tag = $(btn).attr('id');
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token,
               datasheet_id:$('#datasheet_id').val(),
               tag_id:id_tag
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#tag_table_container').html(msg);
            init_tags_events();
        }
    });
}

function remove_tag_from_list(btn)
{
    var url = remove_tag_from_list_url;
    var id_tag = $(btn).attr('id');
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token, 
               datasheet_id:$('#datasheet_id').val(),
               tag_id:id_tag
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#tag_table_container').html(msg);
            init_tags_events();
        }
    });
}

function tag_up_down(arrow)
{
    if ($(arrow).is(".up")) {
        mv = "u";
    } else {
        mv = "d";
    }
    var url = tag_up_down_url;
    var id_tag = $(arrow).attr('id');
    // This indicates the position (from 0) of the tag in the list. NB : it is different from the TagSheet.order in the database.
    var pos_tag = $(arrow).attr('pos');
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token, 
               datasheet_id:$('#datasheet_id').val(),
               tag_id:id_tag,
               move:mv,
               tag_pos:pos_tag
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#tag_table_container').html(msg);
            init_tags_events();
        }
    });
}