'''
Created on Jul 17, 2014

@author: tc
'''
from django.db import models
from renkanmanager.models import Renkan


class HdalabRenkan(models.Model):
    
    EDITION = 1
    PUBLISHED = 2
    MODERATED = 3
    REJECTED = 4
      
    STATE_CHOICES = (
    (EDITION, 'edition'),
    (PUBLISHED, 'published'),
    (MODERATED, 'moderated'),
    (REJECTED, 'rejected'),
    )
    
    renkan = models.ForeignKey(Renkan, blank=False, null=False)
    state = models.IntegerField(choices=STATE_CHOICES, default=1)
    
    class Meta:
        app_label = 'hdalab'
