# -*- coding: utf-8 -*-

from django.test import TestCase
from hdabo.models import Datasheet


class DatasheetTest(TestCase):
    fixtures = ['datasheet_10']
    
    def setUp(self):
        self.datasheet_instance = Datasheet.objects.get(hda_id='1608')
    
    def test_domains_text(self):
        domains_text = self.datasheet_instance.domains_text
        self.assertEqual(u"Arts du quotidien; Arts du visuel", domains_text)

    def test_domains_list(self):
        domains_list = self.datasheet_instance.domains_list
        self.assertListEqual([u"Arts du quotidien", u"Arts du visuel"], domains_list)
    
    def test_tags_text(self):
        tags_text = [s.strip() for s in self.datasheet_instance.tags_text.split(";")]
        tags_text.sort()
        self.assertListEqual(tags_text, [u'XIXe s.', u'XVIIIe s.', u'XVIIe s.', u'XVIe s.', u'affichage', u'affiche', u'afficheur', u'aménagement urbain', u'colonne Morris', u'mobilier urbain', u'ordonnance de François Ier', u'publicité'], "Tags list does not match")
