# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import re

from django.conf import settings
from django.db import models, migrations

def set_site_name(apps, schema_editor):
    Sites = apps.get_model('sites', 'site')
    site = Sites.objects.filter(id=1).first()
    if site == None:
        site = Sites()

    m = re.match(r"^https?\:\/\/(.+)", settings.WEB_URL)
    if m:
        site.name = "HDALab"
        site.domain = m.group(1)
        site.save()

class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0001_initial'),
        ('hdalab', '0002_alter_tagyears_tag_one2one'),
    ]

    operations = [
        migrations.RunPython(set_site_name),
    ]
