import platform

from lib_create_env import lib_generate_install_methods

system_str = platform.system()


INSTALLS = [  # (key,method, option_str, dict_extra_env)
    {'requirement':'requirements.txt',
     'install': {'option_str': None,
                 'dict_extra_env': {'STATIC_DEPS':'true', 'LIBXML2_VERSION': '2.9.2', 'LIBXSLT_VERSION': '1.1.28', 'LIBICONV_VERSION': '1.14'} if system_str == 'Darwin' else None}},
#     'LXML',
#     'PSYCOPG2',
#     'PIL', 
#     'DJANGO',
#     'DJANGO-EXTENSIONS',
#     'REGISTRATION',
#     'SOUTH',
#     'HTTPLIB2',
#     'HAYSTACK',
#     'WHOOSH',
#     'WIKITOOLS',
#     'ISODATE',
#     'RDFLIB',
#     'SPARQLWRAPPER',
#     'PYYAML',
#     'REQUESTS',
#     'PYELASTICSEARCH',
#     'EASYTHUMBNAIL',
    'PKGCONFIG',
    'SQLITE',
    'UNIXODBC',
    'RAPTOR2',
    'RASQAL',
    'REDLAND',
    'REDLAND_BINDINGS',
]

OPTIONS_TO_ADD = {'type_install': 'local', 'unzip_setuptools': True}

def generate_install_methods(path_locations, src_base, run_base, Logger, call_subprocess):    
    return lib_generate_install_methods(path_locations, src_base, run_base, Logger, call_subprocess, INSTALLS, OPTIONS_TO_ADD)
