# -*- coding: utf-8 -*-
'''
Created on Jan 30, 2012

@author: ymh
'''

import logging
from optparse import make_option

from django.conf import settings
from django.core.management.base import NoArgsCommand
from django.core.management.color import no_style

from hdabo.utils import show_progress
from hdalab.models.renkan import HdalabRenkan
from hdalab.services import renkan_capture_preview


logger = logging.getLogger(__name__)

class Command(NoArgsCommand):
    '''
    calculate renkan preview.
    '''
    options = ''
    help = """calculate renkan preview."""
    
    option_list = NoArgsCommand.option_list + (
        make_option('--all',
            action='store_true',
            dest='all',
            default=False,
            help='force all tags to be updated, not only those not yet processed'),
    )
    

    def handle_noargs(self, **options):
                
        self.style = no_style()
        
        self.all = options.get('all', False)

        queryset = HdalabRenkan.objects.filter(state=HdalabRenkan.PUBLISHED)
        
        if not self.all:
            queryset = queryset.filter(renkan__image = settings.DEFAULT_RENKAN_ICON)

        count = queryset.count()

        writer = None
        for i,hdalab_renkan in enumerate(queryset.select_related()):
            writer = show_progress(i+1, count, hdalab_renkan.renkan.title, 50, writer)
            if hdalab_renkan.renkan.image and hdalab_renkan.renkan.image != settings.DEFAULT_RENKAN_ICON:
                hdalab_renkan.renkan.image.delete(False)
                hdalab_renkan.renkan.image.delete_thumbnails()

            renkan_capture_preview(hdalab_renkan)

