# -*- coding: utf-8 -*-
'''
Cette commande transforme une base de donnée hdabo en base de donnée hdalab.
En particulier cette command est utilisée dans l'import de l'extraction rdf des données HDA.

Cette commande enchaine en fait les commandes Django suivantes:

    - `migrate <https://docs.djangoproject.com/en/1.8/ref/django-admin/#django-admin-migrate>`_
    - :mod:`query_wikipedia_category \-f \-\-all <hdalab.management.commands.query_wikipedia_category>` (si l'option est passée)
    - :mod:`query_dbpedia \-f \-\-all <hdalab.management.commands.query_dbpedia>`
    - :mod:`fill_tag_years <hdalab.management.commands.fill_tag_years>`
    - :mod:`geojson_transform \<chemin répertoire data\>/countries.geo.json <hdalab.management.commands.geojson_transform>`
    - :mod:`query_geo_inclusion <hdalab.management.commands.query_geo_inclusion>`
    - :mod:`import_insee_csv \<chemin répertoire data\>/villes.csv <hdalab.management.commands.import_insee_csv>`
    - :mod:`import_insee_csv \<chemin répertoire data\>/additional_cities.csv <hdalab.management.commands.import_insee_csv>`
    - :mod:`import_hda_insee_csv \<chemin répertoire data\>/HDA_Insee.csv <hdalab.management.commands.import_hda_insee_csv>`
    - :mod:`query_category_inclusion \-f \-\-all <hdalab.management.commands.query_category_inclusion>`

**Usage**: ``django-admin import_hdabo_db [options] [<chemin répertoire data>]``

**Options spécifiques:**

    - *\-c,\-\-categories*: ajoute la commande :mod:`query_wikipedia_category \-f \-\-all <hdalab.management.commands.query_wikipedia_category>` à la chaîne de traitements.

'''
from django.core.management.base import BaseCommand
from django.core.management import call_command
from optparse import make_option
import os.path


class Command(BaseCommand):

    args = "[<path to the data folder>]"
    option_list = BaseCommand.option_list + (
        make_option('-c', '--categories',
            action='store_true',
            dest='categories',
            default=False,
            help='load categories in db'),
    )


    def handle(self, *args, **options):

        if len(args) == 0:
            data_path = os.path.abspath(os.path.join(os.path.abspath(__file__),'../../../../../data'))
        else:
            data_path = args[0]

        print("===========  MIGRATE ===========")
        call_command('migrate')
        if options.get('categories', False):
            print("===========  QUERY WIKIPEDIA CATEGORY ===========")
            call_command('query_wikipedia_category', interactive=False, force=True, all=True)

        print("===========  QUERY DBPEDIA ===========")
        call_command('query_dbpedia', interactive=False, force=True, all=True)
        print("===========  FILL TAG YEAR ===========")
        call_command('fill_tag_years')
        print("===========  GEOJSON TRANSFORM ===========")
        call_command('geojson_transform', os.path.join(data_path,'countries.geo.json'))
        print("===========  QUERY GEO INCLUSION ===========")
        call_command('query_geo_inclusion')
        print("===========  IMPORT INSEE CSV PASS 1 ===========")
        call_command('import_insee_csv', os.path.join(data_path,'villes.csv'))
        print("===========  IMPORT INSEE CSV PASS 2 ===========")
        call_command('import_insee_csv', os.path.join(data_path,'additional_cities.csv'))
        print("===========  IMPORT HDA INSEE CSV ===========")
        call_command('import_hda_insee_csv', os.path.join(data_path,'HDA_Insee.csv'))
        print("===========  QUERY CATEGORY INCLUSION ===========")
        call_command('query_category_inclusion', all=True, force=True, interactive=False)

