from lib_create_env import (lib_generate_install_methods, install_pylucene, 
    install_psycopg2, install_pystemmer, install_libyaml)
import platform


system_str = platform.system()

if system_str == 'Windows':
    INSTALLS = [
    ('JCC','easy_install',None,None),
    ('PSYCOPG2',install_psycopg2,None,None),
    ('PYLUCENE','easy_install',None,None),
    ('PYYAML','easy_install',None,None),
    ('PYSTEMMER',install_pystemmer,None,None),
    ]
else:
    INSTALLS = [
    ('PYLUCENE',install_pylucene,None,None),
    ('PSYCOPG2', 'pip', None, None),
#    ('LIBYAML', install_libyaml, None, None)
    ('PYYAML', 'pip', None, None),
    ]

if system_str == 'Linux':
    INSTALLS.extend([
    ('DISTRIBUTE', 'pip', None, None),
    ])

INSTALLS.extend([ #(key,method, option_str, dict_extra_env)
    ('PIL', 'easy_install', None, None), 
    ('DJANGO','pip', None, None),
    ('DJANGO-EXTENSIONS', 'pip', None, None),
    ('HTTPLIB2', 'pip', None, None),
    ('SOUTH', 'pip', None, None),
    ('WHOOSH', 'pip', None, None),
    ('HAYSTACK', 'pip', None, None),
    ('WIKITOOLS', 'pip', None, None),
    ('SPARQLWRAPPER', 'pip', None, None),
])

if system_str == "Darwin":
    INSTALLS.extend([
    ('LXML', 'easy_install', None, {'STATIC_DEPS': 'true', 'LIBXML2_VERSION': '2.7.8', 'LIBXSLT_VERSION': '1.1.26', 'LIBICONV_VERSION': '1.13.1'}),
    ])
else:
    INSTALLS.extend([
    ('LXML', 'easy_install', None, None),
    ])


def generate_install_methods(path_locations, src_base, Logger, call_subprocess):    
    return lib_generate_install_methods(path_locations, src_base, Logger, call_subprocess, INSTALLS)
