# -*- coding: utf-8 -*-
'''
Created on Nov 14, 2014

from https://gist.github.com/gsakkis/601977
to correct https://code.djangoproject.com/ticket/10227

@author: ymh
'''
from django.db import models
from django.db.models import fields as django_fields
from django.core.exceptions import ObjectDoesNotExist


class OneToOneField(models.OneToOneField):    
    def __init__(self, to, **kwargs):
        self.related_default = kwargs.pop('related_default', None)
        super(OneToOneField, self).__init__(to, **kwargs)

    def contribute_to_related_class(self, cls, related):
        setattr(cls, related.get_accessor_name(),
                SingleRelatedObjectDescriptor(related, self.related_default))


class SingleRelatedObjectDescriptor(django_fields.related.SingleRelatedObjectDescriptor):
    def __init__(self, related, default):
        super(SingleRelatedObjectDescriptor, self).__init__(related)
        self.default = default
        
    def __get__(self, instance, instance_type=None):
        try:
            return super(SingleRelatedObjectDescriptor, self).__get__(instance,
                                                                      instance_type)
        except ObjectDoesNotExist:
            if self.default is None:
                raise
            value = self.default(instance)
            setattr(instance, self.cache_name, value)
            if value is not None:
                setattr(value, self.related.field.get_cache_name(), instance)
            return value