# HDALab Docker images

- restore database
-


## Comment construire les container HDALab

Toutes les commandes suivantes sont à effectuer dans le répertoire contenant le fichier `docker-compose.yml`.

```
$ ./prepare_docker_build.sh
$ docker-compose -p hdalab build
$ docker-compose -p hdalab up -d
$ docker-compose -p hdalab exec hdalab django-admin collectstatic --noinput
$ docker-compose -p hdalab exec hdalab django-admin migrate --noinput
$ docker-compose -p hdalab exec hdalab supervisorctl restart all
```

Le site est consultable à l'adresse suivante : [http://127.0.0.1:8080](http://127.0.0.1:8080)
Le système est fonctionnel mais avec une bases de donnée vide.

### Création d'un "superuser"
Cette commande permet la creation d'un utilisateur administeur de l'application.

```
$ docker-compose -p hdalab exec hdalab django-admin createsuperuser
```

### Import des données issues de l'export HDA

Cette commande importe les données RDF exportées à partir de l'application HDA.
Attention cette commande peut être longue.

```
$ docker-compose -p hdalab exec hdalab /usr/local/sbin/import_hda_rdf.sh /etc/hdalab/data /var/lib/hdalab http://data.culture.fr/entrepot/HDA/export.tgz
```

### Import d'un dump de l'application

#### Import d'un dump de la base de donnée

Le fichier de dump de base de données doit être décompressé.

```
$ docker-compose -p hdalab stop hdalab
$ docker exec -i hdalab_pg_1 psql -U iri postgres < </chemin/du/fichier/dump/sql.bckp>
$ docker-compose -p hdalab start hdalab
$ docker-compose -p hdalab exec hdalab django-admin migrate --noinput
$ echo "from django.contrib.sites.models import Site; site=Site.objects.all()[0]; site.domain='127.0.0.1:8080'; site.name='HDALab'; site.save()" | docker exec -i hdalab_hdalab_1 django-admin shell
$ docker-compose -p hdalab exec hdalab django-admin changepassword admin
$ docker-compose -p hdalab exec hdalab django-admin rebuild_index --noinput
```

#### Import des miniatures renkan

Ces commandes supposent que le service `hdalab` est actif.
L'archive comprenant l'export des miniatures doit être décompressé.
Cette archive contient le répertoire `media` à la racine

```
$ docker cp ./media/. hdalab_hdalab_1:/var/lib/hdalab/static/media

```


# Commandes utiles

## liste des services
Les services suivants sont définis dans le fichier `docker-compose.yml`:
 - pg : La base de donnée postgresql
 - es : ElasticSearch
 - mail : Mailhog, fourni un serveur smtp de test
 - front : Le serveur web (nginx)
 - hdalab : application hdalab comprenant l'application web elle-même et les services associés (envoi de mail et calcul des preevisualisations Renkan)

## Démarrage des services

Les services se contrôlent avec la commande `docker-compose`.
La ligne de commande typique est la suivante:

```
$ docker-compose [-f </path/to/docker-compose.yml>] -p hdalab [COMMAND] [ARGS...]
```

Il faut bien noter l'utilisation systématique de l'option `-p hdalab` qui spécifie le nom du projet.
Si la commande est lancée dans le même répertoire que celui du fichier `docker-compose.yml` l'option `-f` peut être ignorée.


## Construction des images des conteneurs
```
$ docker-compose [-f </path/to/docker-compose.yml>] -p hdalab build [SERVICE...]
```

## création et lancement des services
```
$ docker-compose [-f </path/to/docker-compose.yml>] -p hdalab up -d [SERVICE...]
```
A noter l'option `-d` qui mettent les services en tache de fond.

## lancement des services
```
$ docker-compose [-f </path/to/docker-compose.yml>] -p hdalab run SERVICE [COMMAND] [ARGS...]
```
Cette commande lance un service.

## Execution d'une commande sur un service lancé
```
$ docker-compose [-f </path/to/docker-compose.yml>] -p hdalab exec SERVICE COMMAND [ARGS...]
```

## arrêt des services
```
$ docker-compose [-f </path/to/docker-compose.yml>] -p hdalab stop [SERVICE...]
```


## consulter la sortie des containers
```
$ docker-compose [-f </path/to/docker-compose.yml>] -p hdalab logs [-f] [SERVICE...]
```

## effacement et recréation de la base de donnée vide

Attention, toutes les données de la base seront définitivement supprimées.

```
$ docker-compose [-f </path/to/docker-compose.yml>] -p hdalab stop hdalab
$ echo "drop database hdalab;\ncreate database hdalab owner iri encoding 'utf-8';" | docker exec -i hdalab_pg_1 psql -U iri postgres
```

