# -*- coding: utf-8 -*-
# Django settings for hdalab project.
import logging

DEBUG = True

ADMINS = (
    ('Hdalab admin', 'admin@hdalab.test'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.postgresql_psycopg2', # Add 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
        'NAME': 'hdalab',                      # Or path to database file if using sqlite3.
        'USER': 'iri',                      # Not used with sqlite3.
        'PASSWORD': 'iri',                  # Not used with sqlite3.
        'HOST': 'pg',                      # Set to empty string for localhost. Not used with sqlite3.
        'PORT': '',                      # Set to empty string for default. Not used with sqlite3.
    }
}

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.dummy.DummyCache',
    }
}

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# On Unix systems, a value of None will cause Django to use the same
# timezone as the operating system.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Paris'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'fr-fr'

ugettext = lambda s:s

LANGUAGES = (
  ('fr', ugettext('French')),
  ('en', ugettext('English')),
  ('it', ugettext('Italian')),
  ('de', ugettext('German')),
  ('es', ugettext('Spanish')),
  ('ja', ugettext('Japanese')),
  #('zh-tw', ugettext('Chinese')),
)

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale
USE_L10N = True

BASE_DIR = "/var/lib/hdalab/"
BASE_URL = '/'
WEB_URL = 'http://127.0.0.1:8080'
FRONT_WEB_URL = 'http://front:80'
SCRIPT_PREFIX = BASE_URL + 'hdalab'


# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/home/media/media.lawrence.com/media/"
MEDIA_ROOT = '/var/lib/hdalab/static/media/'

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash.
# Examples: "http://media.lawrence.com/media/", "http://example.com/media/"
MEDIA_URL = "/static/media/"

# Absolute path to the directory static files should be collected to.
# Don't put anything in this directory yourself; store your static files
# in apps' "static/" subdirectories and in STATICFILES_DIRS.
# Example: "/home/media/media.lawrence.com/static/"
STATIC_ROOT = '/var/lib/hdalab/static/site/'

# URL prefix for static files.
# Example: "http://media.lawrence.com/static/"
STATIC_URL = '/static/site/'

# URL prefix for admin static files -- CSS, JavaScript and images.
# Make sure to use a trailing slash.
# Examples: "http://foo.com/static/admin/", "/static/admin/".
ADMIN_MEDIA_PREFIX = '/static/site/admin/'

# Additional locations of static files
STATICFILES_DIRS = (
    # Put strings here, like "/home/html/static" or "C:/www/django/static".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
)

# List of finder classes that know how to find static files in
# various locations.
STATICFILES_FINDERS = (
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
#    'django.contrib.staticfiles.finders.DefaultStorageFinder',
)

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'yp-0o!v#a9vswim0*0=jdp1$=*f6cn_o$^u)y53si8u3gs9+r('

# Hosts/domain names that are valid for this site; required if DEBUG is False
# See https://docs.djangoproject.com/en/1.5/ref/settings/#allowed-hosts
ALLOWED_HOSTS = ['hdalab.test', '127.0.0.1']

GOOGLE_ANALYTICS_CODE = 'UA-12345678-9'

HAYSTACK_CONNECTIONS = {
    'default': {
        'ENGINE': 'haystack.backends.elasticsearch_backend.ElasticsearchSearchEngine',
        'URL': 'es:9200',
        'INDEX_NAME': 'hdalab',
    },
}

LOG_FILE = '/var/log/hdalab/hdalab.log'
LOG_LEVEL = logging.DEBUG

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters' : {
        'simple' : {
            'format': "%(asctime)s - %(levelname)s : %(message)s",
        },
        'semi-verbose': {
            'format': '%(levelname)s %(asctime)s %(module)s %(message)s'
        },
    },
    'handlers': {
        'mail_admins': {
            'level': 'ERROR',
            'class': 'django.utils.log.AdminEmailHandler'
        },
        'stream_to_console': {
            'level': LOG_LEVEL,
            'class': 'logging.StreamHandler'
        },
        'file': {
            'level': LOG_LEVEL,
            'class': 'logging.FileHandler',
            'filename': LOG_FILE,
            'formatter': 'semi-verbose',
        },
    }            ,
    'loggers': {
        'hdabo': {
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },
        'hdalab': {
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },
        'rdflib': {
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },
        #  'django.db.backends':{
        #      'handlers': ['file'],
        #      'level': LOG_LEVEL,
        #      'propagate': True,
        #  },
         'django.request': {
             'handlers': ['file'],
             'level': LOG_LEVEL,
             'propagate': True,
         },
    }
}

#template settings
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [
        ],
        'OPTIONS': {
            'context_processors': [
               'django.contrib.auth.context_processors.auth',
               'django.template.context_processors.debug',
               'django.template.context_processors.i18n',
               'django.template.context_processors.media',
               'django.template.context_processors.static',
               'django.template.context_processors.tz',
               'django.contrib.messages.context_processors.messages',
               'hdalab.context_processors.version',
            ],
            'loaders': [
                ('django.template.loaders.cached.Loader', (
                    'django.template.loaders.filesystem.Loader',
                    'django.template.loaders.app_directories.Loader',
                )),
            ],
            'debug': DEBUG,
        },
     },
]


MIDDLEWARE_CLASSES = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.locale.LocaleMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware'
)


ROOT_URLCONF = 'hdalab.urls'


INSTALLED_APPS = (
    'hdalab',
    'hdabo',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.admin',
    'django_extensions',
    'djcelery_email',
    'registration',
    'honeypot',
    'envelope',
    'haystack',
    'easy_thumbnails',
    'renkanmanager',
)


SOUTH_MIGRATION_MODULES = {
    'easy_thumbnails': 'easy_thumbnails.south_migrations',
}
DEFAULT_RENKAN_ICON = "thumbnails/renkan/renkan_default_icon.png"

WIKIPEDIA_VERSION_PERMALINK_TEMPLATE = "http://fr.wikipedia.org/w/index.php?oldid=%s"
DBPEDIA_URI_TEMPLATE = "http://fr.dbpedia.org/%s/%s"

SEARCH_STAR_CHARACTER = "*"
PAGINATION_DEFAULT_NB_BY_PAGE = 50
RENKANS_PER_PAGE = 8

TEST_RUNNER = 'django.test.runner.DiscoverRunner'

# User class after migration to django > 1.6.5
AUTH_USER_MODEL = 'hdabo.User'

ACCOUNT_ACTIVATION_DAYS = 7

LOCALE_PATHS = ()

RENKAN_PREVIEW_DIM = (500,500)
RENKAN_PREVIEW_WAIT = 5000

CELERY_TASK_SERIALIZER = 'json'
CELERY_ACCEPT_CONTENT = ['json', 'msgpack', 'yaml']

EMAIL_BACKEND = 'djcelery_email.backends.CeleryEmailBackend'
EMAIL_HOST="mail"
EMAIL_PORT=1025

SE_ETAGS = False

DEFAULT_FROM_EMAIL = "do-not-reply@hdalab.test"

ENVELOPE_EMAIL_RECIPIENTS= ['histoiredesarts@hdalab.test']

RENKAN_PREVIEW_PHANTOMJS_PATH = '/usr/bin/phantomjs'

BROKER_URL = 'amqp://guest:guest@rabbitmq:5672/hdalab'

RENKAN_TUTORIAL_VIDEO_URLS = [
    {'format': 'video/mp4', 'url': 'http://media.iri.centrepompidou.fr/video/hdalab/hdalab_renkan_presentation_720p.mp4' },
    {'format': 'video/webm', 'url': 'http://media.iri.centrepompidou.fr/video/hdalab/hdalab_renkan_presentation_720p.webm' },
    {'format': 'video/ogg', 'url': 'http://media.iri.centrepompidou.fr/video/hdalab/hdalab_renkan_presentation_720p.ogv' }
]

WIKIPEDIA_API_URL = "https://fr.wikipedia.org/w/api.php"


HONEYPOT_FIELD_NAME='phone'
ENVELOPE_SUBJECT_INTRO='[hdalab contact]'

X_FRAME_OPTIONS='DENY'
SESSION_COOKIE_SECURE=False
SECURE_CONTENT_TYPE_NOSNIFF=True
SECURE_BROWSER_XSS_FILTER=True
CSRF_COOKIE_SECURE=False

#SILENCED_SYSTEM_CHECKS = ['fields.W342'] # to silence a problem in registration module
REGISTRATION_FORM = 'hdabo.forms.HdaboRegistrationForm'
REGISTRATION_EMAIL_HTML = False

OLDER_WINDOWS = [
    u'Windows', u'Windows Mobile', u'Windows XP',
    u'Windows ME', u'Windows 2000', u'Windows NT 4.0',
    u'Windows CE', u'Windows 95', u'Windows 98',
    u'Windows 3.1', u'Windows NT'
]

LOGIN_REDIRECT_URL = "/"
LOGIN_URL = "/hdalab/hdabo/accounts/login"
