/**
 * @author raph
 */

var gomNs = {
    minYear: -5000,
    maxYear: 2010,
    tlPixels: 960,
    tlGamma: 6,
    heatGamma: 4,
}

function yearToPx(year) {
    return gomNs.tlPixels * Math.pow( ( year - gomNs.minYear ) / ( gomNs.maxYear - gomNs.minYear ), gomNs.tlGamma );
}

function pxToYear(px) {
    return gomNs.minYear + ( gomNs.maxYear - gomNs.minYear ) * Math.pow( px / gomNs.tlPixels, 1 / gomNs.tlGamma );
}


function tagInfo(_taglabel) {
    var _urlParam = { "label": _taglabel };
    $.getJSON("taginfo.php",
        _urlParam,
        function(data) {
            var _html = '<div id="addtofilter"><h3>'
                + data.content_count
                + ' contenus pour ce tag</h3><p><a href="#" onclick="filterTag($(\'#tagname\').text()); return false;">Ajouter au filtrage</a></p></div><h2 id="tagname">'
                + data.requested_label
                + '</h2></div>';
            if (data.wikipedia_url) {
                _html += '<h3><a href="'
                    + data.wikipedia_url
                    + '" target="_blank">Wikipédia: '
                    + decodeURI(data.wikipedia_url.match(/[^\/]+$/)[0]).replace("_"," ")
                    + '</a></h3>'
            }
            if (data.thumbnail) {
                _html += '<img id="img_wikipedia" src="'
                    + data.thumbnail
                    + '" />';
            }
            if (data.abstract) {
                _html += '<p>' + _(data.abstract).escape() + '</p>';
            }
            if (data.links) {
                var _lC = data.requested_label.toLowerCase();
                var _t = data.links.map(function(d) {
                    return (d.subject.toLowerCase() == _lC) ? d.object : d.subject;
                });
                _t.sort();
                _t = _(_t).uniq(true);
                _html += '<h3>Tags liés (dbpedia)</h3><ul class="content-tags">'
                    + _t.map(function(d) {
                        return '<li class="content-tag-item"><a href="#" onclick="tagInfo($(this).text()); return false;">'
                            + d
                            + '</a></li>';
                    }).join('')
                    + '</ul>';
            }
            $("#taginfo").html(_html);
        });
    $.getJSON("filter.php", _urlParam, updateDisplay);
    if (gomNs.sessiondata.period || gomNs.sessiondata.filters.tag.length != 1 || gomNs.sessiondata.filters.tag[0] != _taglabel) {
        $("#bandefiltre").attr("class", "inactif");
    } else {
        $("#bandefiltre").attr("class", "");
    }
}

function filterTag(_tagLabel) {
    gomNs.sessiondata.filters.tag.push(_tagLabel);
    updateFilters();
    debouncedSaveChanges();
}

function removeFilter(_index) {
    gomNs.sessiondata.filters.tag.splice(_index,1);
    updateFilters();
    debouncedSaveChanges();
}

function removePeriod() {
    $("#dateslider").slider("values",0,0).slider("values",1,gomNs.tlPixels).slideUp();
    gomNs.sessiondata.filters.period = null;
    updateFilters();
    debouncedSaveChanges();
}

function getUpdates() {
    var _params = {};
    if (gomNs.sessiondata.filters.period) {
        _params.period = gomNs.sessiondata.filters.period.join('|');
    }
    if (gomNs.sessiondata.filters.tag.length) {
        _params.label = gomNs.sessiondata.filters.tag.join('|');
    }
    $.getJSON("filter.php", _params, updateDisplay);
}

var debouncedGetUpdates = _.debounce(getUpdates, 200);

function updateFilters() {
    var _htmFilters = '',
        _fl = gomNs.sessiondata.filters.tag.length;
    if (!gomNs.sessiondata.filters.period && !_fl) {
        _htmFilters = '<li class="nofilter">Aucun filtre</li>';
    }
    if (_fl) {
        _htmFilters += _(gomNs.sessiondata.filters.tag).map(function(_t, _i) {
            return '<li class="filtag">'
                + _t
                + '<a href="#" class="remfil" onclick="removeFilter('
                + _i
                + '); return false;">[x]</a></li>'; 
        }).join("");
    }
    if (gomNs.sessiondata.filters.period) {
        _htmFilters += '<li class="filperiod">' + gomNs.sessiondata.filters.period.join('-') + '<a href="#" class="remfil" onclick="removePeriod(); return false;">[x]</a></li>'
    } else {
        _htmFilters += '<li><a href="#" onclick="$(\'#dateslider\').show(); debouncedHideSlider(); return false;">Filtrer par période</a></li>';
    }
    $("#filters").html(_htmFilters);
    $("#bandefiltre").attr("class","");
    debouncedGetUpdates();
}

function displayContents(contentdata) {
    if (contentdata && contentdata.length) {
        var _htmlCl = '<ul id="contentlist">'
            + contentdata.map(function(_d) {
                return '<li class="content-item"><h3>'
                    + _d.title
                    + '</h3><h4><a href="'
                    + _d.url
                    + '" target="_blank">'
                    + _d.url
                    + '</a></h4><p>'
                    + _d.description
                    + '</p><ul class="content-tags">'
                    + _d.tags.map(function(_t) {
                        return '<li class="content-tag-item"><a href="#" onclick="tagInfo($(this).text()); return false;"'
                            + (_t.match ? ' class="tagmatch"' : '')
                            + '>'
                            + _t.label
                            + '</a></li>';
                    }).join('')
                    + '</ul><h4>Annotations</h4><div class="content-annotation" contentid="'
                    + _d.id
                    + '"><ul><li>'
                    + (gomNs.sessiondata.annotations[_d.id] && gomNs.sessiondata.annotations[_d.id].texte ? gomNs.sessiondata.annotations[_d.id].texte.replace(/\n/gm,"</p><p>") : 'Annoter ce contenu...')
                    + '</li></ul></div>'
                    + '<p><a href="#" class="addtolist" >Ajouter à ma liste</a></p>'
                    + '</li>';
            }).join('')
            + '</ul>';
        $("#contents").html(_htmlCl).scrollTop(0);
        $("div.content-annotation").click(function() {
            if (gomNs.write_allowed && this.children[0].tagName == 'UL') {
            var _el = document.createElement('textarea'),
                _id = this.attributes.contentid.nodeValue;
            _el.innerHTML = (gomNs.sessiondata.annotations[_id] && gomNs.sessiondata.annotations[_id].texte) ? gomNs.sessiondata.annotations[_id].texte : '';
            $(_el).focusout(function() {
                var _id = this.parentNode.attributes.contentid.nodeValue;
                if (!gomNs.sessiondata.annotations[_id]) {
                    gomNs.sessiondata.annotations[_id] = {};
                }
                gomNs.sessiondata.annotations[_id].texte = _.escape(this.value);
                this.parentNode.innerHTML = '<ul><li>' + (this.value.length ? gomNs.sessiondata.annotations[_id].texte.replace(/\n/gm,"</li><li>") : 'Annoter ce contenu...' ) + '</ul>';
                debouncedSaveChanges();
            });
            $(this).html(_el);
            _el.focus();
            _el.select();
        }
        });
    }
    else {
        $("#contents").html("");
    }
}

function updateDisplay(data) {
    if (gomNs.dhmPaper) {
        gomNs.dhmPaper.clear();
    } else {
        gomNs.dhmPaper = new Raphael("dateheat");
    }
    var _s = (data.count>1?'s':'');
    $("#contentcount").html('<b>'+data.count+'</b> notice'+_s);
    var _sl = data.sparkline.length;
    if (_sl) {
        var _maxheat = _(data.sparkline).max(function(_d) { return parseInt(_d.score); }).score,
            _exp = 1 / gomNs.heatGamma,
            _scale = Math.pow(_maxheat, - _exp);
        _(data.sparkline).each(function(_d, _i) {
            var _nxt = (_i == _sl - 1) ? gomNs.maxYear + 1 : data.sparkline[_i + 1].year,
                _x1 = yearToPx(_d.year),
                _x2 = yearToPx(_nxt),
                _heat = _scale * Math.pow(_d.score, _exp);
            gomNs.dhmPaper.rect(_x1, 0, _x2 - _x1, 20).attr({
                "fill" : "rgb(255, 128, 128)",
                "opacity" : _heat,
                "stroke" : "none"
            })
        });
    }
    if (data.tags.length) {
        var _scores = _(data.tags).map(function(_d) { return parseInt(_d.score)}),
            _maxTag = _(_scores).max(),
            _minTag = Math.min(_(_scores).min(), _maxTag - 1),
            _scale = 20 / Math.sqrt(_maxTag - _minTag),
            _htmlTc = '<ul id="tclist">'
            + _(data.tags).map(function(_d) {
                return '<li style="font-size:'
                    + parseInt(10 + _scale * Math.sqrt(_d.score - _minTag))
                    + 'px;"><a href="#" onclick="tagInfo($(this).text()); return false;"'
                    + (_d.match ? ' class="tagmatch"' : '')
                    + '>'
                    + _d.label
                    + '</a></li>';
            }).join('')
            + '</ul>';
        $("#tagcloud").html(_htmlTc);
    }
    else {
        $("#tagcloud").html("<h4>Pas de mots-clés trouvés</h4>");
    }
    displayContents(data.contents);
}

function saveChanges() {
    if (gomNs.sessionid && gomNs.sessionkey) {
        $.getJSON("sessioninfo.php", {
            "sessionid" : gomNs.sessionid,
            "sessionkey" : gomNs.sessionkey,
            "data" : JSON.stringify(gomNs.sessiondata),
        });
    }
}

var debouncedSaveChanges = _.debounce(saveChanges, 1000);

function getInitialView() {
    var _urlParam = {};
    if (document.location.hash) {
        var _tab = document.location.hash.replace("#","").split("-");
        _urlParam.sessionid = _tab[0];
        if (_tab.length > 1) {
            _urlParam.sessionkey = _tab[1];
        }
    }
    $.getJSON("sessioninfo.php", _urlParam, function(data) {
        gomNs.sessionid = data.sessionid;
        if (data.sessionkey) {
            gomNs.sessionkey = data.sessionkey;
        }
        gomNs.write_allowed = data.write_allowed;
        if (data.write_allowed) {
            $("#partagerw").show();
        } else {
            $("#partagerw").hide();
        }
        var _baseUrl = document.location.href.split("#")[0];
        $("#rourl").html(_baseUrl + "#" + data.sessionid );
        gomNs.hash = "#" + data.sessionid + (data.sessionkey ? '-' + data.sessionkey : '');
        document.location.hash = gomNs.hash;
        $("#rwurl").html(_baseUrl + gomNs.hash);
        gomNs.sessiondata = JSON.parse(data.data);
        if (!gomNs.sessiondata.title) {
            gomNs.sessiondata.title = 'Nouvelle session';
        }
        if (!gomNs.sessiondata.filters) {
            gomNs.sessiondata.filters = {
                period : null,
                tag : [],
            }
        }
        if (!gomNs.sessiondata.liste) {
            gomNs.sessiondata.liste = [];
        }
        if (!gomNs.sessiondata.annotations) {
            gomNs.sessiondata.annotations = {};
        }
        $("#sessionname").html(gomNs.sessiondata.title + ( data.write_allowed ? '' : '<span class="lectseul"> (lecture seule)</span>' ) );
        gomNs.hrefinterval = setInterval(function() {
            if (document.location.hash != gomNs.hash) {
                console.log("Changement de hash");
                clearInterval(gomNs.hrefinterval);
                getInitialView();
            }
        }, 500);
        updateFilters();
    });
}

function changeSessionTitle(title) {
    gomNs.sessiondata.title = _.escape(title);
    $("#sessionname").html(gomNs.sessiondata.title);
    debouncedSaveChanges();
}

var debouncedHideSlider = _.debounce(function() {
    $("#dateslider").slideUp();
}, 2000);

$(document).ready(function() {
    $("#dates li").each(function() {
        $(this).css({
            "left" : parseInt(yearToPx(parseInt($(this).text()))) + "px"
        });
    });
    $("#affres").click(function() {
        updateFilters();
        return false;
    });
    $("#apartager").click(function() {
        $("#partageurls").slideToggle();
        return false;
    })
    $( "#dateslider" ).slider({
        range: true,
        min: 0,
        max: gomNs.tlPixels,
        values: [ 0, gomNs.tlPixels ],
        slide: function( event, ui ) {
            gomNs.sessiondata.filters.period = ui.values.map(function(_v) {
                return parseInt(pxToYear(_v));
            });
            updateFilters();
            debouncedSaveChanges();
            debouncedHideSlider();
        }
    }).hide();
    var _defLab = $( "#tagsearch" ).val();
    $( "#tagsearch" ).autocomplete({
        source: "tagsearch.php",
        minLength: 2,
        select: function( event, ui ) {
            tagInfo(ui.item.label);
            $(this).val(_defLab);
            return false;
        }
    }).focusin(function() {
        if ($(this).val() == _defLab) {
            $(this).val("");
        }
    });
    $("#sessionname").click(function() {
        if (gomNs.write_allowed && !$(this).children().length) {
            var _el = document.createElement('input');
            _el.value = gomNs.sessiondata.title;
            $(_el).focusout(function() {
                changeSessionTitle(this.value);
            }).keypress(function(e) {
                if (e.keyCode == 13) {
                    changeSessionTitle(this.value);
                }
            });
            $(this).html(_el);
            _el.focus();
            _el.select();
        }
    });
    getInitialView();
});
