# -*- coding: utf-8 -*-
'''
Created on Jul 01, 2014

@author: tc
'''

from django.views.generic import TemplateView
from hdalab.models.renkan import HdalabRenkan
from hdabo.views import Folders, AddOrUpdateFolder, DeleteFolder

import logging
from django.core.paginator import Paginator, PageNotAnInteger, EmptyPage
from django.conf import settings
logger = logging.getLogger(__name__)


class ManageRenkans(TemplateView):
    template_name = "editorial/manage_renkans.html"
    
    def get_context_data(self, **kwargs):
        context = super(ManageRenkans, self).get_context_data(**kwargs)
        
        sort_param = self.request.GET.get('sort', "date")
        order_param = self.request.GET.get('order', "desc")
        sort = {"date":"renkan__modification_date", "title":"renkan__title", "state":"state", "user":"renkan__owner__username"}.get(sort_param)
        if order_param=="desc":
            order = "-"
            opposite = "asc"
        else:
            order = ""
            opposite = "desc"
        
        rl = HdalabRenkan.objects.exclude(state=HdalabRenkan.EDITION).select_related("renkan", "renkan__owner").order_by(order + sort)
        p = Paginator(rl, settings.RENKANS_PER_PAGE)
        page_nb = self.request.GET.get('page')
        try:
            page = p.page(page_nb)
        except PageNotAnInteger:
            page = p.page(1)
        except EmptyPage:
            page = p.page(p.num_pages)
        
        context.update({"page": page, "sort_param":sort_param, "order_param":order_param, "opposite":opposite})
        
        return context


class HdalabFolders(Folders):
    template_name = "editorial/folders.html"



class HdalabAddOrUpdateFolder(AddOrUpdateFolder):
    template_name = "editorial/add_or_update_folder.html"
    redirect_view = 'hdalab_folders'



class HdalabDeleteFolder(DeleteFolder):
    redirect_view = 'hdalab_folders'