import sys
import os
import os.path
import shutil
import tarfile
import zipfile
import urllib
import platform
import patch
import struct
import glob
import re

join = os.path.join
system_str = platform.system()

URLS = {
    #'': {'setup': '', 'url':'', 'local':''},
    'DISTRIBUTE': {'setup': 'distribute', 'url':'http://pypi.python.org/packages/source/d/distribute/distribute-0.6.24.tar.gz', 'local':"distribute-0.6.24.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO': {'setup': 'django', 'url': 'https://www.djangoproject.com/download/1.6.8/tarball/', 'local':"Django-1.6.8.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'DJANGO-EXTENSIONS': { 'setup': 'django-extensions', 'url':'https://github.com/django-extensions/django-extensions/archive/1.4.4.tar.gz', 'local':"django-extensions-1.4.4.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'REGISTRATION': { 'setup': 'django-registration', 'url':'https://github.com/macropin/django-registration/archive/v1.1.tar.gz', 'local':"django-registration-1.1.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'HTTPLIB2': { 'setup': 'httplib2', 'url':'https://github.com/jcgregorio/httplib2/archive/v0.9.tar.gz', 'local':"httplib2-0.7.4.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'SOUTH': { 'setup': 'South', 'url':'http://www.aeracode.org/releases/south/south-1.0.1.tar.gz', 'local':"South-1.0.1.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'PYCRYPTO': {'setup': 'pycrypto', 'url':'https://github.com/dlitz/pycrypto/archive/v2.6.1.tar.gz', 'local':'pycrypto-2.6.1.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'SSH': {'setup': 'ssh', 'url':'http://pypi.python.org/packages/source/s/ssh/ssh-1.7.14.tar.gz#md5=4cdd0549ef4699bd67b96264d3b21427', 'local':'ssh-1.7.14.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'FABRIC': {'setup': 'fabric', 'url':'https://github.com/fabric/fabric/tarball/1.4.2', 'local':'fabric-1.4.2.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'MERCURIAL': {'setup': 'mercurial', 'url':'http://mercurial.selenic.com/release/mercurial-2.2.3.tar.gz', 'local':'mercurial-2.2.3.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'HAYSTACK': {'setup': 'django-haystack', 'url': 'https://github.com/toastdriven/django-haystack/archive/v2.2.0.tar.gz', 'local': 'django-haystack-2.2.0.tar.gz', 'install':{'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'WHOOSH': {'setup': 'whoosh', 'url':'https://pypi.python.org/packages/source/W/Whoosh/Whoosh-2.5.7.tar.gz', 'local':'whoosh-2.5.7.tar.gz', 'install' : {'method':'pip', 'option_str': None, 'dict_extra_env': None}},
    'WIKITOOLS' : { 'setup': 'wikitools', 'url': 'https://github.com/alexz-enwp/wikitools/archive/1.2.tar.gz', 'local': 'wikitools-1.2.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'ISODATE' : {'setup': 'isodate', 'url': 'http://pypi.python.org/packages/source/i/isodate/isodate-0.5.1.tar.gz', 'local': 'isodate-0.5.1.tar.gz', 'install' : {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'RDFLIB' : { 'setup': 'rdflib', 'url': 'https://github.com/IRI-Research/rdflib/archive/30f0f8ca7dba3e9dbfef39fb2006e4b395748f6c.tar.gz', 'local': 'rdflib-4.2.0-dev.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'SPARQLWRAPPER' : { 'setup': 'SPARQLWrapper', 'url': 'https://github.com/RDFLib/sparqlwrapper/archive/1.6.4.tar.gz', 'local' : 'SPARQLWrapper-1.6.4.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},    
    'REQUESTS' : { 'setup': 'requests', 'url': 'https://github.com/kennethreitz/requests/archive/v2.4.3.tar.gz', 'local' : 'requests-2.4.3.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'ELASTICSEARCH' : { 'setup': 'elasticsearch', 'url': 'https://github.com/elasticsearch/elasticsearch-py/archive/1.2.0.tar.gz', 'local' : 'elasticsearch-1.2.0.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'PYPARSING' : { 'setup': 'pyparsing', 'url': 'https://pypi.python.org/packages/source/p/pyparsing/pyparsing-2.0.3.tar.gz', 'local' : 'pyparsing-2.0.3.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'PIL' : { 'setup': 'pil', 'url': 'http://effbot.org/downloads/Imaging-1.1.7.tar.gz', 'local' : 'Imaging-1.1.7.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'EASYTHUMBNAIL' : { 'setup': 'easy-thumbnail', 'url': 'https://github.com/SmileyChris/easy-thumbnails/archive/2.2.tar.gz', 'local' : 'easy-thumbnails-2.2.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'SIX' : { 'setup': 'six', 'url': 'https://pypi.python.org/packages/source/s/six/six-1.8.0.tar.gz', 'local' : 'six-1.8.0.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'SIMPLEJSON' : { 'setup': 'simplejson', 'url': 'https://github.com/simplejson/simplejson/archive/v3.6.5.tar.gz', 'local' : 'simplejson-3.6.5.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'HTML5LIB' : { 'setup': 'html5lib', 'url': 'https://github.com/html5lib/html5lib-python/archive/0.999.tar.gz', 'local' : 'html5lib-0.999.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'URLLIB3': { 'setup': 'urllib3', 'url':'https://github.com/shazow/urllib3/archive/1.9.1.tar.gz', 'local':"urllib3-1.9.1.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'PKGCONFIG': { 'setup': 'pkg-config', 'url':'pkg-config-0.28.tar.gz', 'local':"pkg-config-0.28.tar.gz", 'install': {'method': 'install_pkgconfig', 'option_str': None, 'dict_extra_env': None}},
    'SQLITE': { 'setup': 'SQLITE', 'url':'sqlite-autoconf-3080701.tar.gz', 'local':"sqlite-autoconf-3080701.tar.gz", 'install': {'method': 'install_sqlite', 'option_str': None, 'dict_extra_env': None}},
    'UNIXODBC': { 'setup': 'unixODBC', 'url':'unixODBC-2.3.2.tar.gz', 'local':"unixODBC-2.3.2.tar.gz", 'install': {'method': 'install_unixODBC', 'option_str': None, 'dict_extra_env': None}},
    'RAPTOR2': { 'setup': 'raptor2', 'url':'raptor2-2.0.15.tar.gz', 'local':"raptor2-2.0.15.tar.gz", 'install': {'method': 'install_raptor2', 'option_str': None, 'dict_extra_env': None}},
    'RASQAL': { 'setup': 'rasqal', 'url':'rasqal-0.9.32.tar.gz', 'local':"rasqal-0.9.32.tar.gz", 'install': {'method': 'install_rasqal', 'option_str': None, 'dict_extra_env': None}},
    'REDLAND': { 'setup': 'redland', 'url':'redland-1.0.17.tar.gz', 'local':"redland-1.0.17.tar.gz", 'install': {'method': 'install_redland', 'option_str': None, 'dict_extra_env': None}},
    'REDLAND_BINDINGS': { 'setup': 'redland_bindings', 'url':'redland-bindings-1.0.17.1.tar.gz', 'local':"redland-bindings-1.0.17.1.tar.gz", 'install': {'method': 'install_redland_bindings', 'option_str': None, 'dict_extra_env': None}},
    'UNIDECODE': { 'setup': 'unidecode', 'url':'https://pypi.python.org/packages/source/U/Unidecode/Unidecode-0.04.17.tar.gz', 'local':"Unidecode-0.04.17.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'PYTZ': { 'setup': 'pytz', 'url':'https://pypi.python.org/packages/source/p/pytz/pytz-2014.10.tar.bz2', 'local':"pytz-2014.10.tar.bz2", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'KOMBU': { 'setup': 'kombu', 'url':'https://github.com/celery/kombu/archive/v3.0.24.tar.gz', 'local':"kombu-3.0.24.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'AMQP': { 'setup': 'amqp', 'url':'https://github.com/celery/py-amqp/archive/v1.4.6.tar.gz', 'local':"py-amqp-1.4.6.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'ANYJSON': { 'setup': 'anyjson', 'url':'https://bitbucket.org/runeh/anyjson/get/0.3.3.tar.gz', 'local':"anyjson-0.3.3.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'BILLIARD': { 'setup': 'billiard', 'url':'https://github.com/celery/billiard/archive/v3.3.0.19.tar.gz', 'local':"billiard-3.3.0.19.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    'CELERY': { 'setup': 'celery', 'url':'https://github.com/celery/celery/archive/v3.1.17.tar.gz', 'local':"celery-3.1.17.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
}



if system_str == 'Windows':
    
    URLS.update({
        'PSYCOPG2': {'setup': 'psycopg2','url': 'psycopg2-2.0.14.win32-py2.6-pg8.4.3-release.zip', 'local':"psycopg2-2.0.14.win32-py2.6-pg8.4.3-release.zip", 'install': {'method': 'install_psycopg2', 'option_str': None, 'dict_extra_env': None}},
        'PIL': {'setup': 'pil', 'url': 'http://effbot.org/media/downloads/PIL-1.1.7.win32-py2.6.exe', 'local':"PIL-1.1.7.win32-py2.6.exe", 'install': {'method': 'easy_install', 'option_str': None, 'dict_extra_env': None}},
        'LXML': {'setup': 'lxml', 'url': 'http://pypi.python.org/packages/2.6/l/lxml/lxml-2.2.2-py2.6-win32.egg', 'local':"lxml-2.2.2-py2.6-win32.egg", 'install': {'method': 'easy_install', 'option_str': None, 'dict_extra_env': None}},
        'PYYAML' : { 'setup': 'PyYAML', 'url': 'http://pyyaml.org/download/pyyaml/PyYAML-3.09.win32-py2.6.exe', 'local': 'PyYAML-3.09.win32-py2.6.exe', 'install': {'method': 'easy_install', 'option_str': None, 'dict_extra_env': None}},
        'PYSTEMMER' : { 'setup': 'pystemmer', 'url': 'PyStemmer_compiled_for_pc.zip', 'local': 'PyStemmer_compiled_for_pc.zip'},
    })
else:
    if system_str == "Darwin":
        lxml_options = {'STATIC_DEPS': 'true', 'LIBXML2_VERSION': '2.9.2', 'LIBXSLT_VERSION': '1.1.28', 'LIBICONV_VERSION': '1.14'}
    else:
        lxml_options = None

    URLS.update({
        'PSYCOPG2': {'setup': 'psycopg2','url': 'http://initd.org/psycopg/tarballs/PSYCOPG-2-5/psycopg2-2.5.4.tar.gz', 'local':"psycopg2-2.5.4.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
        'PIL': {'setup': 'pil', 'url': 'http://effbot.org/downloads/Imaging-1.1.7.tar.gz', 'local':"Imaging-1.1.7.tar.gz", 'install': {'method': 'easy_install', 'option_str': None, 'dict_extra_env': None}},
        'LXML': {'setup': 'lxml', 'url':"lxml-3.4.0.tar.gz", 'local':"lxml-3.4.0.tar.gz", 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': lxml_options}},
        'PYYAML' : { 'setup': 'PyYAML', 'url': 'http://pyyaml.org/download/pyyaml/PyYAML-3.11.tar.gz', 'local': 'PyYAML-3.11.tar.gz', 'install': {'method': 'pip', 'option_str': None, 'dict_extra_env': None}},
    })
    

class ResourcesEnv(object):

    def __init__(self, src_base, run_base, urls, normal_installs):
        self.src_base = src_base
        self.run_base = run_base
        self.URLS = {}
        self.__init_url(urls)
        self.NORMAL_INSTALL = normal_installs

    def get_src_base_path(self, fpath):
        return os.path.abspath(os.path.join(self.src_base, fpath)).replace("\\","/")

    def get_run_res_base_path(self, fpath):
        return os.path.abspath(os.path.join(self.run_base, 'res', fpath)).replace("\\","/")    
    
    def __add_package_def(self, key, dict):
        self.URLS[key] = dict
        
    def __init_url(self, urls):
        for key, url_dict in urls.items():
            url_dict_copy = url_dict.copy()
            if url_dict.get('install', {}).get('method','pip') == 'pip-req':
                get_base_path = self.get_run_res_base_path
            else:
                get_base_path = self.get_src_base_path
            if not url_dict['url'].startswith("http://"):
                url_dict_copy['url'] = get_base_path(url_dict['url'])
            url_dict_copy['local'] = get_base_path(url_dict['local'])

            self.__add_package_def(key, url_dict_copy )

def ensure_dir(dir, logger):
    logger.notify('Check directory %s' % dir)
    if not os.path.exists(dir):
        logger.notify('Creating directory %s' % dir)
        os.makedirs(dir)

def extend_parser(parser):    
    parser.add_option(
        '--index-url',
        metavar='INDEX_URL',
        dest='index_url',
        default='http://pypi.python.org/simple/',
        help='base URL of Python Package Index')
    parser.add_option(
        '--type-install',
        metavar='type_install',
        dest='type_install',
        help='type install : local, url, setup - default : local')
    parser.add_option(
        '--ignore-packages',
        metavar='ignore_packages',
        dest='ignore_packages',
        default=None,
        help='list of comma separated keys for package to ignore')
    parser.add_option(
        '--no-clear',
        metavar='do not clear env',
        dest='clear',
        default=True,
        action='store_false',
        help='do not clear env')



def install_psycopg2(option_str, extra_env, res_source_key, home_dir, lib_dir, tmp_dir, src_dir, res_env, logger, call_subprocess, filter_python_develop):
    psycopg2_src = os.path.join(src_dir,"psycopg2.zip")
    shutil.copy(res_env.URLS['PSYCOPG2'][res_source_key], psycopg2_src)
    #extract psycopg2
    zf = zipfile.ZipFile(psycopg2_src)
    psycopg2_base_path = os.path.join(src_dir,"psycopg2")
    zf.extractall(psycopg2_base_path)
    zf.close()
    
    psycopg2_src_path = os.path.join(psycopg2_base_path, os.listdir(psycopg2_base_path)[0])
    shutil.copytree(os.path.join(psycopg2_src_path, 'psycopg2'), os.path.abspath(os.path.join(home_dir, 'Lib/site-packages', 'psycopg2')))
    shutil.copy(os.path.join(psycopg2_src_path, 'psycopg2-2.4.5-py2.7.egg-info'), os.path.abspath(os.path.join(home_dir, 'Lib/site-packages', 'site-packages')))
    


def gen_install_comp_lib(lib_name, lib_key, configure_options=[], configure_env={}):
    
    def install_lib(option_str, extra_env, res_source_key, home_dir, lib_dir, tmp_dir, src_dir, res_env, logger, call_subprocess, filter_python_develop):
        lib_src = os.path.join(src_dir,lib_name+".tar.gz")
        logger.notify("Copy %s to %s " % (res_env.URLS[lib_key][res_source_key],lib_src))
        shutil.copy(res_env.URLS[lib_key][res_source_key], lib_src)
        tf = tarfile.open(lib_src,'r:gz')
        lib_base_path = os.path.join(src_dir, lib_name) 
        logger.notify("Extract %s to %s " % (lib_name,lib_base_path))
        tf.extractall(lib_base_path)
        tf.close()
        
        lib_src_path = os.path.join(lib_base_path, os.listdir(lib_base_path)[0])
        
        
        context_map = {
            'option_str' : option_str,
            'home_dir': os.path.abspath(home_dir),
            'lib_dir': os.path.abspath(lib_dir),
            'tmp_dir': os.path.abspath(tmp_dir),
            'src_dir': os.path.abspath(src_dir),
        }
        
        configure_options_trans = map(lambda s: s % context_map, configure_options)
        configure_env_trans = {k: s % context_map for k,s in configure_env.items()}
    
        logger.notify(lib_name + " configure in " + lib_src_path)
        call_subprocess(['./configure', '--prefix='+os.path.abspath(home_dir)] + configure_options_trans,
                        cwd=os.path.abspath(lib_src_path),
                        filter_stdout=filter_python_develop,
                        show_stdout=True,
                        extra_env=configure_env_trans
                        )
        
        logger.notify(lib_name + " make in " + lib_src_path)
        call_subprocess(['make'],
                        cwd=os.path.abspath(lib_src_path),
                        filter_stdout=filter_python_develop,
                        show_stdout=True)
    
        logger.notify(lib_name + "make install in " + lib_src_path)
        call_subprocess(['make', 'install'],
                        cwd=os.path.abspath(lib_src_path),
                        filter_stdout=filter_python_develop,
                        show_stdout=True)
    return install_lib

install_libjpeg = gen_install_comp_lib("libjpeg", "LIBJPEG", ['--enable-shared'], {})
install_zlib = gen_install_comp_lib("zlib", "ZLIB", [], {})
install_pkgconfig = gen_install_comp_lib("pkg-config", "PKGCONFIG", ['--with-internal-glib'], {})
install_sqlite = gen_install_comp_lib("sqlite", "SQLITE", [], {})
install_unixODBC = gen_install_comp_lib("unixODBC", "UNIXODBC", ['--enable-gui=no'], {})
redland_base_env = {
    'PKG_CONFIG': "%(home_dir)s/bin/pkg-config",
    'PKG_CONFIG_LIBDIR': "%(home_dir)s/lib/pkgconfig",
}
install_raptor2 = gen_install_comp_lib('raptor2', 'RAPTOR2', [], redland_base_env)
install_rasqal = gen_install_comp_lib('rasqal', "RASQAL", [], redland_base_env)
install_redland = gen_install_comp_lib('redland', 'REDLAND', [], dict(redland_base_env.items() + {'CFLAGS':'-I%(home_dir)s/include'}.items()))
python_ld_flags = '-L'+os.path.abspath(os.path.join(os.path.dirname(os.__file__),'..'))+' -lpython'+".".join(map(str,sys.version_info[0:2]))
if sys.platform == 'darwin':
    python_ld_flags += ' -Wl,-dylib'
elif 'linux' in sys.platform:
    python_ld_flags += ' -nostartfiles -Wl,-shared'
install_redland_bindings = gen_install_comp_lib('redland-bindings', "REDLAND_BINDINGS", ['--with-python=%(home_dir)s/bin/python', '--with-python-ldflags='+python_ld_flags], redland_base_env)

def install_pystemmer(option_str, extra_env, res_source_key, home_dir, lib_dir, tmp_dir, src_dir, res_env, logger, call_subprocess, filter_python_develop):
    print "install PYSTEMMER from " + res_env.URLS['PYSTEMMER'][res_source_key]
    pystemmer_src = os.path.join(src_dir,"pystemmer.zip")
    shutil.copy(res_env.URLS['PYSTEMMER'][res_source_key], pystemmer_src)
    #extract pystemmer
    zf = zipfile.ZipFile(pystemmer_src)
    pystemmer_base_path = os.path.join(src_dir,"pystemmer")
    zf.extractall(pystemmer_base_path)
    zf.close()
    
    shutil.copy(os.path.join(pystemmer_base_path, 'Stemmer.pyd'), os.path.abspath(os.path.join(home_dir, 'Lib/site-packages')))
    shutil.copy(os.path.join(pystemmer_base_path, 'PyStemmer-1.0.1-py2.6.egg-info'), os.path.abspath(os.path.join(home_dir, 'Lib/site-packages')))
    
#osx_extra_env = {'ARCHFLAGS': '-Wno-error=unused-command-line-argument-hard-error-in-future', 'CFLAGS': '-Qunused-arguments', 'CPPFLAGS': '-Qunused-arguments'}
osx_extra_env = {}

def lib_generate_install_methods(path_locations, src_base, run_base, Logger, call_subprocess, normal_installs, options_to_add=None, urls= None):
    
    all_urls = URLS.copy()
    if urls is not None:
        all_urls.update(urls)
        
    res_env = ResourcesEnv(src_base, run_base, all_urls, normal_installs)

    def filter_python_develop(line):
        if not line.strip():
            return Logger.DEBUG
        for prefix in ['Searching for', 'Reading ', 'Best match: ', 'Processing ',
                       'Moving ', 'Adding ', 'running ', 'writing ', 'Creating ',
                       'creating ', 'Copying ']:
            if line.startswith(prefix):
                return Logger.DEBUG
        return Logger.NOTIFY
    
    
    def normal_install(key, res_path, method, option_str, extra_env, res_source_key, home_dir, tmp_dir, res_env, logger, call_subprocess):
        logger.notify("Install %s from %s with %s" % (key,res_path,method))
        if method == 'pip':
            if sys.platform == 'win32':
                args = [os.path.abspath(os.path.join(home_dir, 'Scripts', 'pip')), 'install', res_path]
            else:
                args = [os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), 'install', res_path]
            if option_str :
                args.append(option_str)
            if res_source_key == 'local':
                if extra_env is None:
                    extra_env = {}
                extra_env["PIP_DOWNLOAD_CACHE"] = res_env.get_src_base_path("")
                args.insert(2, '-f')
                args.insert(3, res_env.get_src_base_path(""))
                args.insert(4, '--no-index')
            logger.notify("Install %s from %s with %s args %s " % (key,res_path,method, repr(args)))
            call_subprocess(args,
                    cwd=os.path.abspath(tmp_dir),
                    filter_stdout=filter_python_develop,
                    show_stdout=True,
                    extra_env=extra_env)
        if method == 'pip-req':
            if sys.platform == 'win32':
                args = [os.path.abspath(os.path.join(home_dir, 'Scripts', 'pip')), 'install', '-r', res_path]
            else:
                args = [os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), 'install', '-r', res_path]
            if option_str :
                args.append(option_str)
            if res_source_key == 'local':
                if extra_env is None:
                    extra_env = {}
                extra_env["PIP_DOWNLOAD_CACHE"] = res_env.get_src_base_path("")
                args.insert(2, '-f')
                args.insert(3, res_env.get_src_base_path(""))
                args.insert(4, '--no-index')
            logger.notify("Install %s from %s with %s args %s " % (key,res_path,method, repr(args)))
            call_subprocess(args,
                    cwd=os.path.abspath(tmp_dir),
                    filter_stdout=filter_python_develop,
                    show_stdout=True,
                    extra_env=extra_env)
        else:
            if sys.platform == 'win32':
                args = [os.path.abspath(os.path.join(home_dir, 'Scripts', 'easy_install')), res_path]
            else:
                args = [os.path.abspath(os.path.join(home_dir, 'bin', 'easy_install')), res_path]
            if option_str :
                args.insert(1,option_str)
            call_subprocess(args,
                    cwd=os.path.abspath(tmp_dir),
                    filter_stdout=filter_python_develop,
                    show_stdout=True,
                    extra_env=extra_env)
 
    
    def after_install(options, home_dir):
        
        global logger
        
        verbosity = options.verbose - options.quiet
        logger = Logger([(Logger.level_for_integer(2-verbosity), sys.stdout)])

        
        home_dir, lib_dir, inc_dir, bin_dir = path_locations(home_dir)
        base_dir = os.path.dirname(home_dir)
        src_dir = os.path.join(home_dir, 'src')
        tmp_dir = os.path.join(home_dir, 'tmp')
        ensure_dir(src_dir, logger)
        ensure_dir(tmp_dir, logger)
        system_str = platform.system()
                
        res_source_key = getattr(options, 'type_install') if hasattr(options, 'type_install') else 'local' #.get('type_install', 'local')
        if res_source_key is None:
            res_source_key = 'local'
        
        ignore_packages = []
        
        if system_str == 'Windows':
            default_install_options = {'method': 'easy_install', 'option_str': None, 'dict_extra_env': {}}
        else:
            default_install_options = {'method': 'pip', 'option_str': None, 'dict_extra_env': {}}
            
        if options.ignore_packages :
            ignore_packages = options.ignore_packages.split(",")
        
        logger.indent += 2
        try:    
            for key in res_env.NORMAL_INSTALL:
                install_options = None
                if isinstance(key, dict):
                    install_options = key.get('install', default_install_options)
                    install_options['method'] = 'pip-req'
                    res_path = res_env.get_run_res_base_path(key['requirement'])
                else:
                    if key not in res_env.URLS:
                        logger.notify("%s not found in def : passing" % (key,))
                    install_options = res_env.URLS[key].get('install', None)
                    res_path = res_env.URLS[key][res_source_key]
                if install_options is None:
                    install_options = default_install_options
                method = install_options.get('method', default_install_options['method'])
                option_str = install_options.get('option_str', default_install_options['option_str'])
                extra_env = install_options.get('dict_extra_env', default_install_options['dict_extra_env'])
                if not extra_env:
                    extra_env = {}
                    
                if 'TMPDIR' not in extra_env:
                    extra_env['TMPDIR'] = os.path.abspath(tmp_dir)
                if system_str == 'Darwin':
                    for flag_key, flag_value in iter(osx_extra_env.items()):
                        flags = extra_env.get(flag_key, '')
                        if flag_value not in flags:
                            #flags += " -Wno-error=unused-command-line-argument-hard-error-in-future"
                            flags += " "+flag_value
                            extra_env[flag_key] = flags.strip()
                    
                #isinstance(lst, (list, tuple))
                if key not in ignore_packages:
                    logger.notify("install %s with method %s" % (key, repr(method)))
                    if callable(method):
                        method(option_str, extra_env, res_source_key, home_dir, lib_dir, tmp_dir, src_dir, res_env, logger, call_subprocess, filter_python_develop)
                    elif method in globals() and callable(globals()[method]) and method not in ['pip', 'easy_install']:  
                        globals()[method](option_str, extra_env, res_source_key, home_dir, lib_dir, tmp_dir, src_dir, res_env, logger, call_subprocess, filter_python_develop)
                    else:
                        normal_install(key, res_path, method, option_str, extra_env, res_source_key, home_dir, tmp_dir, res_env, logger, call_subprocess)
                            
            logger.notify("Clear source dir")
            shutil.rmtree(src_dir)
    
        finally:
            logger.indent -= 2
        script_dir = join(base_dir, bin_dir)
        logger.notify('Run "%s Package" to install new packages that provide builds'
                      % join(script_dir, 'easy_install'))
    
    def adjust_options(options, args):
        if not options_to_add:
            return
        for opt,opt_val in options_to_add.items():
            #if not hasattr(options,test_opt) or getattr(options, test_opt) is None:
            setattr(options, opt, opt_val)

    return adjust_options, extend_parser, after_install

