# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.utils.timezone
from django.conf import settings
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('auth', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(default=django.utils.timezone.now, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(help_text='Required. 30 characters or fewer. Letters, digits and @/./+/-/_ only.', unique=True, max_length=30, verbose_name='username', validators=[django.core.validators.RegexValidator('^[\\w.@+-]+$', 'Enter a valid username.', 'invalid')])),
                ('first_name', models.CharField(max_length=30, verbose_name='first name', blank=True)),
                ('last_name', models.CharField(max_length=30, verbose_name='last name', blank=True)),
                ('email', models.EmailField(max_length=75, verbose_name='email address', blank=True)),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('groups', models.ManyToManyField(related_query_name='user', related_name='user_set', to='auth.Group', blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of his/her group.', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(related_query_name='user', related_name='user_set', to='auth.Permission', blank=True, help_text='Specific permissions for this user.', verbose_name='user permissions')),
            ],
            options={
                'db_table': 'auth_user',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('hda_id', models.CharField(unique=True, max_length=512)),
                ('lastname', models.CharField(max_length=512, null=True, blank=True)),
                ('firstname', models.CharField(max_length=512, null=True, blank=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Datasheet',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('hda_id', models.CharField(unique=True, max_length=512)),
                ('title', models.CharField(max_length=2048, serialize=False)),
                ('description', models.TextField(serialize=False, null=True, blank=True)),
                ('url', models.URLField(serialize=False, max_length=2048, null=True, blank=True)),
                ('original_creation_date', models.DateField(serialize=False)),
                ('original_modification_date', models.DateField(serialize=False)),
                ('modification_datetime', models.DateTimeField(auto_now=True, serialize=False)),
                ('validation_date', models.DateTimeField(serialize=False, null=True, blank=True)),
                ('validated', models.BooleanField(default=False, db_index=True)),
                ('manual_order', models.BooleanField(default=False, serialize=False, db_index=True)),
                ('author', models.ForeignKey(serialize=False, blank=True, to='hdabo.Author', null=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Datasheet_college_periods',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('sort_value', models.IntegerField()),
                ('datasheet', models.ForeignKey(to='hdabo.Datasheet')),
            ],
            options={
                'ordering': ['sort_value'],
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Datasheet_college_themes',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('sort_value', models.IntegerField()),
                ('datasheet', models.ForeignKey(to='hdabo.Datasheet')),
            ],
            options={
                'ordering': ['sort_value'],
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Datasheet_domains',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('sort_value', models.IntegerField()),
                ('datasheet', models.ForeignKey(to='hdabo.Datasheet')),
            ],
            options={
                'ordering': ['sort_value'],
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Datasheet_highschool_periods',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('sort_value', models.IntegerField()),
                ('datasheet', models.ForeignKey(to='hdabo.Datasheet')),
            ],
            options={
                'ordering': ['sort_value'],
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Datasheet_highschool_themes',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('sort_value', models.IntegerField()),
                ('datasheet', models.ForeignKey(to='hdabo.Datasheet')),
            ],
            options={
                'ordering': ['sort_value'],
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Datasheet_primary_periods',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('sort_value', models.IntegerField()),
                ('datasheet', models.ForeignKey(to='hdabo.Datasheet')),
            ],
            options={
                'ordering': ['sort_value'],
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Datasheet_primary_themes',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('sort_value', models.IntegerField()),
                ('datasheet', models.ForeignKey(to='hdabo.Datasheet')),
            ],
            options={
                'ordering': ['sort_value'],
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='DocumentFormat',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('label', models.CharField(unique=True, max_length=512)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Domain',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('label', models.CharField(max_length=512)),
                ('school_period', models.IntegerField(choices=[(0, 'Global'), (1, 'Primaire'), (2, 'Coll\xe8ge'), (3, 'Lyc\xe9e')])),
                ('natural_key', models.CharField(unique=True, max_length=512)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Folder',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('url', models.URLField(unique=True, max_length=2048)),
                ('title', models.CharField(max_length=2048, null=True, blank=True)),
                ('description', models.TextField(null=True, blank=True)),
                ('datasheets', models.ManyToManyField(to='hdabo.Datasheet')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=512)),
                ('insee', models.CharField(unique=True, max_length=5)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Organisation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('hda_id', models.CharField(unique=True, max_length=512)),
                ('name', models.CharField(max_length=512)),
                ('location', models.CharField(max_length=512, null=True, blank=True)),
                ('website', models.CharField(max_length=2048, null=True, blank=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('label', models.CharField(max_length=1024, db_index=True)),
                ('alternative_label', models.CharField(max_length=1024, null=True, blank=True)),
                ('normalized_label', models.CharField(max_length=1024, editable=False, db_index=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('original_label', models.CharField(max_length=1024, editable=False)),
                ('alias', models.CharField(max_length=1024, null=True, blank=True)),
                ('wikipedia_url', models.URLField(db_index=True, max_length=2048, null=True, blank=True)),
                ('wikipedia_pageid', models.BigIntegerField(db_index=True, null=True, blank=True)),
                ('alternative_wikipedia_url', models.URLField(db_index=True, max_length=2048, null=True, blank=True)),
                ('alternative_wikipedia_pageid', models.BigIntegerField(db_index=True, null=True, blank=True)),
                ('url_status', models.IntegerField(default=None, null=True, db_index=True, blank=True, choices=[(0, b'null_result'), (1, b'redirection'), (2, b'homonyme'), (3, b'match'), (4, b'unsematized')])),
                ('dbpedia_uri', models.URLField(db_index=True, max_length=2048, null=True, blank=True)),
                ('popularity', models.IntegerField(default=0, db_index=True)),
                ('natural_key', models.CharField(max_length=7168, db_index=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='TagCategory',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('label', models.CharField(unique=True, max_length=512)),
                ('natural_key', models.CharField(max_length=512, db_index=True)),
            ],
            options={
                'verbose_name_plural': 'TagCategories',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='TaggedSheet',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('original_order', models.IntegerField(default=0)),
                ('order', models.IntegerField(default=0, db_index=True)),
                ('index_note', models.FloatField(default=0.0, db_index=True)),
                ('wikipedia_revision_id', models.BigIntegerField(null=True, blank=True)),
                ('datasheet', models.ForeignKey(to='hdabo.Datasheet')),
                ('tag', models.ForeignKey(to='hdabo.Tag')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='TimePeriod',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('label', models.CharField(max_length=512)),
                ('school_period', models.IntegerField(choices=[(1, 'Primaire'), (2, 'Coll\xe8ge'), (3, 'Lyc\xe9e')])),
                ('natural_key', models.CharField(unique=True, max_length=512)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.AlterUniqueTogether(
            name='timeperiod',
            unique_together=set([('label', 'school_period')]),
        ),
        migrations.AddField(
            model_name='tag',
            name='category',
            field=models.ForeignKey(blank=True, to='hdabo.TagCategory', null=True),
            preserve_default=True,
        ),
        migrations.AlterUniqueTogether(
            name='tag',
            unique_together=set([('label', 'original_label', 'url_status')]),
        ),
        migrations.AlterUniqueTogether(
            name='domain',
            unique_together=set([('label', 'school_period')]),
        ),
        migrations.AddField(
            model_name='datasheet_primary_themes',
            name='domain',
            field=models.ForeignKey(to='hdabo.Domain'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet_primary_periods',
            name='timeperiod',
            field=models.ForeignKey(to='hdabo.TimePeriod'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet_highschool_themes',
            name='domain',
            field=models.ForeignKey(to='hdabo.Domain'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet_highschool_periods',
            name='timeperiod',
            field=models.ForeignKey(to='hdabo.TimePeriod'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet_domains',
            name='domain',
            field=models.ForeignKey(to='hdabo.Domain'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet_college_themes',
            name='domain',
            field=models.ForeignKey(to='hdabo.Domain'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet_college_periods',
            name='timeperiod',
            field=models.ForeignKey(to='hdabo.TimePeriod'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='college_periods',
            field=models.ManyToManyField(related_name='college_periods_datasheets', serialize=False, through='hdabo.Datasheet_college_periods', to='hdabo.TimePeriod'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='college_themes',
            field=models.ManyToManyField(related_name='college_themes_datasheets', serialize=False, through='hdabo.Datasheet_college_themes', to='hdabo.Domain'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='domains',
            field=models.ManyToManyField(related_name='datasheets', serialize=False, through='hdabo.Datasheet_domains', to='hdabo.Domain'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='format',
            field=models.ForeignKey(serialize=False, blank=True, to='hdabo.DocumentFormat', null=True),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='highschool_periods',
            field=models.ManyToManyField(related_name='highschool_periods_datasheets', serialize=False, through='hdabo.Datasheet_highschool_periods', to='hdabo.TimePeriod'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='highschool_themes',
            field=models.ManyToManyField(related_name='highschool_themes_datasheets', serialize=False, through='hdabo.Datasheet_highschool_themes', to='hdabo.Domain'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='organisation',
            field=models.ForeignKey(serialize=False, to='hdabo.Organisation', null=True),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='primary_periods',
            field=models.ManyToManyField(related_name='primary_periods_datasheets', serialize=False, through='hdabo.Datasheet_primary_periods', to='hdabo.TimePeriod'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='primary_themes',
            field=models.ManyToManyField(related_name='primary_themes_datasheets', serialize=False, through='hdabo.Datasheet_primary_themes', to='hdabo.Domain'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='tags',
            field=models.ManyToManyField(to='hdabo.Tag', serialize=False, through='hdabo.TaggedSheet'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='town',
            field=models.ForeignKey(serialize=False, blank=True, to='hdabo.Location', null=True),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='datasheet',
            name='validator',
            field=models.ForeignKey(serialize=False, blank=True, to=settings.AUTH_USER_MODEL, null=True),
            preserve_default=True,
        ),
    ]
