# -*- coding: utf-8 -*-
from django.conf.urls.defaults import patterns, include, url
from django.contrib import admin
from django.views.generic import TemplateView
#from hdalab.views.ajax import filter

# Uncomment the next two lines to enable the admin:
# from django.contrib import admin
# admin.autodiscover()

urlpatterns = patterns('',
    # Examples:
    # url(r'^$', 'hdalab.views.home', name='home'),
    # url(r'^hdalab/', include('hdalab.foo.urls')),

    # Uncomment the admin/doc line below to enable admin documentation:
    # url(r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    url(r'^admin/', include(admin.site.urls)),
    
    url(r'^i18n/', include('django.conf.urls.i18n')),
    url('^jsi18n/?$', 'django.views.i18n.javascript_catalog', name='jsi18n.all'),
    url('^jsi18n/(?P<packages>\S+?)/$', 'django.views.i18n.javascript_catalog', {'domain':'djangojs'}, name='jsi18n'),
    
    url(r'^facettes/', TemplateView.as_view(template_name="facettes.html"), name='facettes'),
    url(r'^categories/', TemplateView.as_view(template_name="categories.html"), name='categories'),
    url(r'^completion/', TemplateView.as_view(template_name="completion.html"), name='completion'),
    url(r'^$', TemplateView.as_view(template_name="index.html"), name='home'),

)

urlpatterns += patterns('hdalab.views.ajax',
    (r'^a/filter$', 'filter', {}, 'filter'),
    (r'^a/sessioninfo$', 'sessioninfo', {}, 'session_info'),
    (r'^a/tagsearch$', 'tagsearch', {}, 'tag_search'),
    (r'^a/catsearch$', 'catsearch', {}, 'cat_search'),
    (r'^a/cattree$', 'cattree', {}, 'cat_tree'),
    (r'^a/filltree$', 'filltree', {}, 'fill_tree'),
    (r'^a/contentsbytag$', 'contentsbytag', {}, 'contentsbytag'),
)
