'''
Created on Jan 26, 2012

@author: ymh
'''
from django.db import models
from hdabo.models import Tag


class WpCategory(models.Model):
    label = models.CharField(max_length=2048, unique=True, blank=False, null=False)
    
    def __unicode__(self):
        return unicode(self.label)
    
    class Meta:
        app_label = 'hdalab'
        verbose_name_plural = "WpCategories"

class TagWpCategory(models.Model):
    tag = models.ForeignKey(Tag, related_name="wp_categories")
    wp_category = models.ForeignKey(WpCategory, related_name="tags")
    hidden = models.BooleanField(blank=False, null=False, default=False)
    
    class Meta:
        app_label = 'hdalab'
        unique_together = ('tag', 'wp_category', 'hidden')

class TagInfobox(models.Model):
    tag = models.ForeignKey(Tag, related_name="infoboxes")
    name = models.CharField(max_length=2048, unique=False, blank=False, null=False)
    source = models.TextField(unique=False, blank=True, null=True)
    revision_id = models.BigIntegerField(unique=False, blank=True, null=True)
    
    class Meta:
        app_label = 'hdalab'
        unique_together = ('tag','name','revision_id')
    
class InfoboxParameter(models.Model):
    tag_infobox = models.ForeignKey(TagInfobox)
    param_name = models.CharField(max_length=2048, unique=False, blank=False, null=False)
    param_value = models.TextField(unique=False, blank=True, null=True)

    class Meta:
        app_label = 'hdalab'
        unique_together = ('tag_infobox','param_name')

# Added on 02/07/2012

class WpCategoryInclusion(models.Model):
    parent_category = models.ForeignKey(WpCategory, related_name="child_categories")
    child_category = models.ForeignKey(WpCategory, related_name="parent_categories")
    
    class Meta:
        app_label = 'hdalab'
        unique_together = ('parent_category','child_category')