from django.template import Library, TemplateSyntaxError

register = Library()

import logging
logger = logging.getLogger(__name__)

@register.filter
def short_url(value):
    """ Takes a full url http://www.anything.com/anything/anything/end and return anything.com[...]end """
    # Error management
    if value is None :
        return ""
    if not isinstance(value, (str,unicode)) :
        raise TemplateSyntaxError('urlify value error : string is required')
    if value[:7]=="http://":
        value = value[7:]
    if value[:4]=="www.":
        value = value[4:]
    if len(value)>35:
        value = value[:15] + "[...]" + value[-15:]
             
    return value
short_url.is_safe = True


