from django.template import Library, TemplateSyntaxError
from hdalab.models.renkan import HdalabRenkan

register = Library()

import logging
logger = logging.getLogger(__name__)

@register.filter
def state_to_str(value):
    """  """
    # Error management
    if value is None or not isinstance(value, int) :
        raise TemplateSyntaxError('status_to_str value error : int is required')
    return HdalabRenkan.STATE_CHOICES_DICT.get(value, "")
state_to_str.is_safe = True


