/* Saves the Full JSON once */

Rkns.jsonIOSaveOnClick = function(_renkan, _opts) {
    var _proj = _renkan.project,
        _saveWarn = false,
        _onLeave = function() {
            return "Project not saved";
        };
    if (typeof _opts.http_method === "undefined") {
        _opts.http_method = 'POST';
    }
    var _load = function() {
        var getdata = {},
            rx = /id=([^&#?=]+)/,
            matches = document.location.hash.match(rx);
        if (matches) {
            getdata.id = matches[1];
        }
        Rkns.$.ajax({
            url: _opts.url,
            data: getdata,
            success: function(_data) {
                _proj.set(_data, {validate: true});
            	_renkan.renderer.autoScale();
            	// Green color when user is authenticated
            	if(_opts.user_authenticated==true){
            	    $(".Rk-Save-Button").addClass("Rk-Save-Online");
            	}
            }
        });
    };
    var _save = function() {
        _proj.set("saved_at", new Date());
        var _data = _proj.toJSON();
        Rkns.$.ajax({
            type: _opts.http_method,
            url: _opts.url,
            contentType: "application/json",
            data: JSON.stringify(_data),
            success: function(data, textStatus, jqXHR) {
                console.log("RMS success !", data);
                $(window).off("beforeunload", _onLeave);
                _saveWarn = false;
                if(data.substr(0,6)=="rk_id="){
                    _opts.url = _opts.url.split("?")[0] + "?" + data;
                }
            }
        });
    };
    var _checkLeave = function() {
        var title = _proj.get("title");
        if (title && _proj.get("nodes").length) {
            $(".Rk-Save-Button").removeClass("disabled");
        } else {
            $(".Rk-Save-Button").addClass("disabled");
        }
        if (title) {
            $(".Rk-PadTitle").css("border-color","#333333");
        }
        if (!_saveWarn) {
            _saveWarn = true;
            $(window).on("beforeunload", _onLeave);
        }
    };
    _load();
    _proj.on("add:nodes add:edges add:users change", function(_model) {
        _model.on("change remove", function(_model) {
            _checkLeave();
        });
        _checkLeave();
    });
    _renkan.renderer.save = function() {
        console.log("RMS _renkan.renderer.save _opts.user_authenticated = ", _opts.user_authenticated);
        if(_opts.user_authenticated==true){
            if ($(".Rk-Save-Button").hasClass("disabled")) {
                if (!_proj.get("title")) {
                    $(".Rk-PadTitle").css("border-color","#ff0000");
                }
            } else {
                _save();
            }
        }
        else{
            //$(".Rk-Notifications").text("Connecte-toi bordel !").fadeIn().delay(2000).fadeOut();
            dialog.dialog( "open" );
        }
    };
};
