# encoding: utf-8
from south.db import db
from south.v2 import SchemaMigration

class Migration(SchemaMigration):

    def forwards(self, orm):
        
        # Adding model 'WpCategory'
        db.create_table('hdalab_wpcategory', ( #@UndefinedVariable
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('label', self.gf('django.db.models.fields.CharField')(unique=True, max_length=2048)),
        ))
        db.send_create_signal('hdalab', ['WpCategory']) #@UndefinedVariable

        # Adding model 'TagWpCategory'
        db.create_table('hdalab_tagwpcategory', ( #@UndefinedVariable
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('tag', self.gf('django.db.models.fields.related.ForeignKey')(related_name='wp_categories', to=orm['hdabo.Tag'])),
            ('wp_category', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdalab.WpCategory'])),
            ('hidden', self.gf('django.db.models.fields.BooleanField')(default=False)),
        ))
        db.send_create_signal('hdalab', ['TagWpCategory']) #@UndefinedVariable

        # Adding unique constraint on 'TagWpCategory', fields ['tag', 'wp_category', 'hidden']
        db.create_unique('hdalab_tagwpcategory', ['tag_id', 'wp_category_id', 'hidden']) #@UndefinedVariable

        # Adding model 'TagInfobox'
        db.create_table('hdalab_taginfobox', ( #@UndefinedVariable
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('tag', self.gf('django.db.models.fields.related.ForeignKey')(related_name='infoboxes', to=orm['hdabo.Tag'])),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=2048)),
            ('source', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('revision_id', self.gf('django.db.models.fields.BigIntegerField')(null=True, blank=True)),
        ))
        db.send_create_signal('hdalab', ['TagInfobox']) #@UndefinedVariable

        # Adding unique constraint on 'TagInfobox', fields ['tag', 'name', 'revision_id']
        db.create_unique('hdalab_taginfobox', ['tag_id', 'name', 'revision_id']) #@UndefinedVariable

        # Adding model 'InfoboxParameter'
        db.create_table('hdalab_infoboxparameter', ( #@UndefinedVariable
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('tag_infobox', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdalab.TagInfobox'])),
            ('param_name', self.gf('django.db.models.fields.CharField')(max_length=2048)),
            ('param_value', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
        ))
        db.send_create_signal('hdalab', ['InfoboxParameter']) #@UndefinedVariable

        # Adding unique constraint on 'InfoboxParameter', fields ['tag_infobox', 'param_name']
        db.create_unique('hdalab_infoboxparameter', ['tag_infobox_id', 'param_name']) #@UndefinedVariable


    def backwards(self, orm):
        
        # Removing unique constraint on 'InfoboxParameter', fields ['tag_infobox', 'param_name']
        db.delete_unique('hdalab_infoboxparameter', ['tag_infobox_id', 'param_name']) #@UndefinedVariable

        # Removing unique constraint on 'TagInfobox', fields ['tag', 'name', 'revision_id']
        db.delete_unique('hdalab_taginfobox', ['tag_id', 'name', 'revision_id']) #@UndefinedVariable

        # Removing unique constraint on 'TagWpCategory', fields ['tag', 'wp_category', 'hidden']
        db.delete_unique('hdalab_tagwpcategory', ['tag_id', 'wp_category_id', 'hidden']) #@UndefinedVariable

        # Deleting model 'WpCategory'
        db.delete_table('hdalab_wpcategory') #@UndefinedVariable

        # Deleting model 'TagWpCategory'
        db.delete_table('hdalab_tagwpcategory') #@UndefinedVariable

        # Deleting model 'TagInfobox'
        db.delete_table('hdalab_taginfobox') #@UndefinedVariable

        # Deleting model 'InfoboxParameter'
        db.delete_table('hdalab_infoboxparameter') #@UndefinedVariable


    models = {
        'hdabo.tag': {
            'Meta': {'unique_together': "(('label', 'original_label', 'url_status'),)", 'object_name': 'Tag'},
            'alias': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'alternative_label': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'alternative_wikipedia_pageid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'alternative_wikipedia_url': ('django.db.models.fields.URLField', [], {'max_length': '2048', 'null': 'True', 'blank': 'True'}),
            'category': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.TagCategory']", 'null': 'True', 'blank': 'True'}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'dbpedia_uri': ('django.db.models.fields.URLField', [], {'max_length': '2048', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'label': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'db_index': 'True'}),
            'normalized_label': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'db_index': 'True'}),
            'original_label': ('django.db.models.fields.CharField', [], {'max_length': '1024'}),
            'popularity': ('django.db.models.fields.IntegerField', [], {'default': '0', 'db_index': 'True'}),
            'url_status': ('django.db.models.fields.IntegerField', [], {'default': 'None', 'null': 'True', 'blank': 'True'}),
            'wikipedia_pageid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'wikipedia_url': ('django.db.models.fields.URLField', [], {'max_length': '2048', 'null': 'True', 'blank': 'True'})
        },
        'hdabo.tagcategory': {
            'Meta': {'object_name': 'TagCategory'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'label': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '512'})
        },
        'hdalab.infoboxparameter': {
            'Meta': {'unique_together': "(('tag_infobox', 'param_name'),)", 'object_name': 'InfoboxParameter'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'param_name': ('django.db.models.fields.CharField', [], {'max_length': '2048'}),
            'param_value': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'tag_infobox': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdalab.TagInfobox']"})
        },
        'hdalab.taginfobox': {
            'Meta': {'unique_together': "(('tag', 'name', 'revision_id'),)", 'object_name': 'TagInfobox'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '2048'}),
            'revision_id': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'source': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'tag': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'infoboxes'", 'to': "orm['hdabo.Tag']"})
        },
        'hdalab.tagwpcategory': {
            'Meta': {'unique_together': "(('tag', 'wp_category', 'hidden'),)", 'object_name': 'TagWpCategory'},
            'hidden': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'tag': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'wp_categories'", 'to': "orm['hdabo.Tag']"}),
            'wp_category': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdalab.WpCategory']"})
        },
        'hdalab.wpcategory': {
            'Meta': {'object_name': 'WpCategory'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'label': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '2048'})
        }
    }

    complete_apps = ['hdalab']
