from django.contrib.auth.models import Group
from django.db import models
from django.db.models import Model


class Branding(Model):

    name = models.CharField(max_length=255, unique=True, blank=True, null=True)
    group = models.ForeignKey(Group, null=True)
    
    def __unicode__(self):
        return unicode(self.id) + u"::" + unicode(self.name)
    
    class Meta:
        app_label = "hashcut"
    
    
class Mashup(Model):
    
    project = models.ForeignKey("ldt_utils.Project", null=True)
    branding = models.ForeignKey("Branding")
    
    def __unicode__(self):
        return unicode(self.id) + u"::" + unicode(self.branding.name) + u"::" + unicode(self.project.owner) + u"::" + unicode(self.project.ldt_id)
    
    def creator(): #@NoSelf
        def fget(self):
            if self.project is not None:
                return self.project.owner
            else:
                return None
        return locals()
    
    creator = property(**creator())
    
    class Meta:
        app_label = "hashcut"