IriSP.Hashcut = function() {
    
    /* Load Media List */
    
    var directory = new IriSP.Model.Directory(),
        project = directory.remoteSource({
            url: "data/bpidata.json",
            serializer: IriSP.serializers.medialist
        }),
        mediatemplate = '<li class="item-video" data-media-id="{{id}}"><img src="{{thumbnail}}" alt="{{title}}" />'
            + '<span class="video-info"><span class="title-video">{{title}}</span><span class="author">{{description}}</span>'
            + '<span class="time-length">Durée : <span>{{duration}}</span></span></span></li>';

    /* Fill left column with Media List */
    
    project.onLoad(function() {
        var html = '';
        project.getMedias().forEach(function(_m) {
            html += Mustache.to_html(mediatemplate, _m);
        });
        $(".col-left .list-video").html(html);
    });
    
    /* Search Media with left column form */
    
    $(".col-left input").on("keyup change input paste", function() {
        var val = $(this).val();
        if (val) {
            var find = IriSP.Model.regexpFromTextOrArray(val, true),
                replace = IriSP.Model.regexpFromTextOrArray(val, false);
        }
        $(".col-left .item-video").each(function() {
            var li = $(this),
                title = $(this).find(".title-video"),
                titletext = title.text();
            if (val && find.test(titletext)) {
                title.html(titletext.replace(replace, '<span style="background: yellow;">$1</span>'));
                li.show();
            } else {
                title.text(titletext);
                if (val) {
                    li.hide();
                } else {
                    li.show();
                }
            }
        })
    });
    
    /* Slider */
   
    var timeSlider = $(".Ldt-Slider"),
        slidersRange = 920;
    timeSlider.slider({
        range: "min",
        value: 0,
        min: 0,
        max: slidersRange,
        slide: function(event, ui) {
            if (currentMedia) {
                var t = currentMedia.duration * ui.value / slidersRange;
                currentMedia.setCurrentTime(t);
            }
        }
    });
    
    var timeSliderHandle = timeSlider.find('.ui-slider-handle'),
        timeSliderMaximized = false,
        timeSliderTimeoutId = false,
        timeSliderMinimizedHeight = 4,
        timeSliderMaximizedHeight = 10,
        timeSliderTimeoutDuration = 1500,
        timeTooltip = $(".Ldt-Slider-Time");
    
    timeSlider.css(calculateSliderCss(timeSliderMinimizedHeight));
    timeSliderHandle.css(calculateHandleCss(timeSliderMinimizedHeight));
    
    function timeSliderMouseOver() {
        if (timeSliderTimeoutId) {
            window.clearTimeout(timeSliderTimeoutId);
            timeSliderTimeoutId = false;
        }
        if (!timeSliderMaximized) {
           timeSliderAnimateToHeight(timeSliderMaximizedHeight);
           timeSliderMaximized = true;
        }
    }
    
    function timeSliderMouseOut() {
        timeTooltip.hide();
        if (timeSliderTimeoutId) {
            clearTimeout(timeSliderTimeoutId);
            timeSliderTimeoutId = false;
        }
        timeSliderTimeoutId = setTimeout(function() {
            if (timeSliderMaximized) {
                timeSliderAnimateToHeight(timeSliderMinimizedHeight);
                timeSliderMaximized = false;
            }
            timeSliderTimeoutId = false;
        }, timeSliderTimeoutDuration);
    }
    
    timeSlider
        .mouseover(function() {
            timeTooltip.show();
            timeSliderMouseOver();
        })
        .mouseout(timeSliderMouseOut)
        .mousemove(function(_e) {
            var _x = _e.pageX - timeSlider.offset().left,
                _t = new IriSP.Model.Time(
                    currentMedia ? currentMedia.duration * _x / timeSlider.width() : 0
                );
            timeTooltip.text(_t.toString()).css("left",_x);
        });
    
    $(".Ldt-Ctrl").mouseover(timeSliderMouseOver).mouseout(timeSliderMouseOut);
    
    function timeSliderAnimateToHeight(_height) {
        timeSlider.stop().animate(
            calculateSliderCss(_height),
            500,
            function() {
                IriSP.jQuery(this).css("overflow","visible");
            });
        timeSliderHandle.stop().animate(
            calculateHandleCss(_height),
            500,
            function() {
                IriSP.jQuery(this).css("overflow","visible");
            });
    }

    function calculateSliderCss(_size) {
        return {
            height: _size + "px",
            "margin-top": (timeSliderMinimizedHeight - _size) + "px"
        };
    }

    function calculateHandleCss(_size) {
        return {
            height: (2 + _size) + "px",
            width: (2 + _size) + "px",
            "margin-left": -Math.ceil(2 + _size / 2) + "px" 
        }
    }
    
    /* Controller Widget */
   
    var volBlock = $(".Ldt-Ctrl-Volume-Control");
    $('.Ldt-Ctrl-Sound')
        .click(function(){}) //TODO: Add Mute and Volume Handlers
        .mouseover(function() {
            volBlock.show();
        })
        .mouseout(function() {
            volBlock.hide();
        });
    volBlock.mouseover(function() {
        volBlock.show();
    }).mouseout(function() {
        volBlock.hide();
    });
    
    var volBar = $(".Ldt-Ctrl-Volume-Bar");
    volBar.slider({
        slide: function(event, ui) {
            volBar.attr("title",'Volume : ' + ui.value + '%');
            //_this.media.setVolume(ui.value / 100);
        },
        stop: function() {
            // IriSP.Widgets.Controller.prototype.volumeUpdater
        }
    });
    
    $(".Ldt-Ctrl-Play").click(function() {
        if (currentMedia) {
            if (currentMedia.getPaused()) {        
                currentMedia.play();
            } else {
                currentMedia.pause();
            }
        }
    });
    
    /* Slice Widget */
    var sliceSlider = $(".Ldt-Slice"),
        sliceStartTime;
        
    function setTangles(sliderValues) {
        //TODO: Move to Annotation.on("changebounds")
        if (currentMedia) {
            startTime = new IriSP.Model.Time(currentMedia.duration * sliderValues[0] / slidersRange),
            endTime = new IriSP.Model.Time(currentMedia.duration * sliderValues[1] / slidersRange),
            duration = new IriSP.Model.Time(endTime - startTime);
            $(".tangle-start").text(startTime.toString()).attr("data-milliseconds",startTime.milliseconds);
            $(".tangle-end").text(endTime.toString()).attr("data-milliseconds",endTime.milliseconds);
            $(".tangle-duration").text(duration.toString()).attr("data-milliseconds",duration.milliseconds);
        }
    }
    
    sliceSlider.slider({
        range: true,
        values: [0, slidersRange],
        min: 0,
        max: slidersRange,
        change: function(event, ui) {
            setTangles(ui.values); // Not the right place to put it
        },
        start: function() {
            if (currentMedia) {
                if (!currentMedia.getPaused()) {
                    currentMedia.pause();
                }
//                sliceStartTime = currentMedia.getCurrentTime(); 
            }
        },
        slide: function(event, ui) {
            if (currentMedia) {
                var t = currentMedia.duration * ui.value / slidersRange;
                currentMedia.setCurrentTime(t);
            }
            setTangles(ui.values);
        },
        stop: function() {
            if (currentMedia && sliceStartTime) {
//                currentMedia.setCurrentTime(sliceStartTime);
            }
        }
    });
    
    sliceSlider.find(".ui-slider-handle:first").addClass("Ldt-Slice-left-handle");
    sliceSlider.find(".ui-slider-handle:last").addClass("Ldt-Slice-right-handle");
    
    /* UI Events */

    function onCurrentMediaPlay() {
        $(".Ldt-Ctrl-Play")
            .attr("title", "Pause")
            .removeClass("Ldt-Ctrl-Play-PlayState")
            .addClass("Ldt-Ctrl-Play-PauseState")
    }
    
    function onCurrentMediaPause() {
        $(".Ldt-Ctrl-Play")
            .attr("title", "Lecture")
            .removeClass("Ldt-Ctrl-Play-PauseState")
            .addClass("Ldt-Ctrl-Play-PlayState")
    }
    
    function onCurrentMediaTimeupdate(_time) {
        $(".Ldt-Ctrl-Time-Elapsed").text(_time.toString());
        timeSlider.slider("value",slidersRange * _time / currentMedia.duration);
    }
    
    /* Set current Media */
    var currentMedia;
    
    function setMedia(mediaid) {
        $(".col-left .item-video").removeClass("active");
        $(".tutorial").hide();
        $("video").hide();
        if (currentMedia) {
            currentMedia.pause();
        }
        currentMedia = project.getElement(mediaid);
        if (currentMedia.elementType == "media") {
            $(".col-left .item-video[data-media-id='" + mediaid + "']").addClass("active");
            showSegmentation();
            var currentvideo = $('#video_' + mediaid);
            if (!currentvideo.length) {
                addMediaPlayer(currentMedia);
                currentvideo = $('#video_' + mediaid);
            }
            $(".tab-media-title").text(currentMedia.title);
            sliceSlider.slider("values",[0, slidersRange]);
        }
        currentvideo.show();
        $(".Ldt-Ctrl-Time-Total").text(currentMedia.duration.toString());
        onCurrentMediaTimeupdate(currentMedia.getCurrentTime());
        onCurrentMediaPause();
    }
    
    function addMediaPlayer(media) {
        var videoid = "video_" + media.id,
            videoEl = $('<video>'),
            width = $(".video").width(),
            height = $(".video").height(),
            mp4_file = media.video.replace(/\.webm$/i,'.mp4'),
            webm_file = media.video.replace(/\.mp4$/i,'.webm'),
            mp4_src = $('<source>'),
            webm_src = $('<source>');
        mp4_src.attr({
            src: mp4_file,
            type: "video/mp4"
        });
        webm_src.attr({
            src: webm_file,
            type: "video/webm"
        });
        videoEl.attr({
            id : videoid,
            width : width,
            height : height
        }).css({
            position : "absolute",
            left: 0,
            top: 0,
            width : width,
            height : height
        });
        videoEl.append(mp4_src).append(webm_src);
        $(".video").append(videoEl);

        var popcorn = Popcorn("#" + videoid);
        
        // Binding functions to Popcorn
        
        media.on("setcurrenttime", function(_milliseconds) {
            popcorn.currentTime(_milliseconds / 1000);
        });
        
        media.on("setvolume", function(_vol) {
            popcorn.volume(_vol);
            media.volume = _vol;
        });
        
        media.on("setmuted", function(_muted) {
            popcorn.muted(_muted);
            media.muted = _muted;
        });
        
        media.on("setplay", function() {
            popcorn.play();
        });
        
        media.on("setpause", function() {
            popcorn.pause();
        });
        
        // Binding Popcorn events to media
        
        function getVolume() {
            media.muted = popcorn.muted();
            media.volume = popcorn.volume();
        }
        
        popcorn.on("loadedmetadata", function() {
            getVolume();
            media.trigger("loadedmetadata");
            media.trigger("volumechange");
        })
        
        popcorn.on("timeupdate", function() {
            media.trigger("timeupdate", new IriSP.Model.Time(1000*popcorn.currentTime()));
        });
        
        popcorn.on("volumechange", function() {
            getVolume();
            media.trigger("volumechange");
        })
        
        popcorn.on("play", function() {
            media.trigger("play");
        });
        
        popcorn.on("pause", function() {
            media.trigger("pause");
        });
        
        popcorn.on("seeked", function() {
            media.trigger("seeked");
        });
        
        // Binding UI Events to Media
        
        media.on("play", function() {
            if (media === currentMedia) {
                onCurrentMediaPlay();
            }
        });
        
        media.on("pause", function() {
            if (media === currentMedia) {
                onCurrentMediaPause();
            }
        });
        
        media.on("timeupdate", function(_time) {
            if (media === currentMedia) {
                onCurrentMediaTimeupdate(_time);
            }
        })
        
    }
    /* Click on media items */
   
    $(".col-left").on("click", ".item-video", function() {
        setMedia($(this).attr("data-media-id"));
    });
    
    /* Click on Tabs */
    
    function showSegmentation() {
        $(".col-middle").removeClass("empty-mode pvw-mode").addClass("segment-mode");
        return false;
    }
    function showPreview() {
        $(".col-middle").removeClass("empty-mode segment-mode").addClass("pvw-mode");
        return false;
    }
    
    $(".tab-pvw").click(showPreview);
    
    function disableMoveItemVideo() {
        $(".organize-segments .top, .organize-segments .bottom").removeClass("disable");
        $(".organize-segments .item-video:last-child .bottom, .organize-segments .item-video:first-child .top").addClass("disable");
    }
    
    $(".organize-segments").sortable({
        stop : function(){
            disableMoveItemVideo();
        }
    });
    
    $(".organize-segments .top").click(function(e){
        var currentItem = $(this).parents(".item-video");
        currentItem.insertBefore(currentItem.prev());
        disableMoveItemVideo();
    });
    
    $(".organize-segments .bottom").click(function(e){
        var currentItem = $(this).parents(".item-video");
        currentItem.insertAfter(currentItem.next());
        disableMoveItemVideo();
    });
    
    /* Tangle */
    var activeTangle,
        tangleStartX,
        tangleStartVal;
    $(".time-tangle").mousedown(function(evt) {
        activeTangle = $(this);
        activeTangle.addClass("active");
        tangleStartVal = +activeTangle.attr("data-milliseconds");
        tangleStartX = evt.pageX;
        return false;
    });
    $(document)
        .mousemove(function(evt) {
            if (activeTangle) {
                var newval = new IriSP.Model.Time(100 * (evt.pageX - tangleStartX) + tangleStartVal);
                activeTangle.text(newval.toString());
                activeTangle.attr("data-milliseconds",newval.milliseconds);
                activeTangle.trigger("valuechange", newval);
                return false;
            }
        })
        .mouseup(function() {
            if (activeTangle) {
                activeTangle.removeClass("active");
                activeTangle = undefined;
            }
        })
    
}

$(function() {
    var hashcut = new IriSP.Hashcut();
});
