from django.core.exceptions import ImproperlyConfigured
from django.views.generic.base import View, TemplateResponseMixin
from ldt.ldt_utils.models import Project


class MashupHome(TemplateResponseMixin, View):
    
    # iri = default brand name
    brand_name = "iri"
    template_suffix = "mashup_home.html"
    template_name = "iri_mashup_home.html"
    
    def get_template_names(self):
        """
        Return a list of template names to be used for the request. Must return
        a list. May not be called if get_template is overridden.
        """
        try:
            names = super(MashupHome, self).get_template_names()
        except ImproperlyConfigured:
            raise ImproperlyConfigured("Class MashupHome requires either a definition of 'template_name'")

        # the branding template is supposed to override the default template. So we insert instead of append
        if self.brand_name and self.brand_name != "":
            #names.insert(0,"%s_%s" % (self.brand_name, self.template_name))
            names.insert(0,"%s_%s" % (self.brand_name, self.template_suffix))
        
        return names
    
    
    def get(self, request, branding=None, **kwargs):
        if branding and branding!="":
            self.brand_name = branding
        projects = Project.safe_objects.all()[:10]
        p1 = projects[0]
        p2 = projects[1]
        projects = projects[2:]
        context = {"coucou":self.brand_name, "projects":projects, "p1":p1, "p2":p2}
        return self.render_to_response(context)