IriSP.Hashcut = function() {
    
    /* Load Media List */
    
    var directory = new IriSP.Model.Directory(),
        project = directory.remoteSource({
            url: "data/bpidata.json",
            serializer: IriSP.serializers.medialist
        }),
        mediatemplate = '<li class="item-video" data-media-id="{{id}}"><img src="{{thumbnail}}" alt="{{title}}" />'
            + '<span class="video-info"><span class="title-video">{{title}}</span><span class="author">{{description}}</span>'
            + '<span class="time-length">Durée : <span>{{duration}}</span></span></span></li>';

    /* Fill left column with Media List */
    
    project.onLoad(function() {
        var html = '';
        project.getMedias().forEach(function(_m) {
            html += Mustache.to_html(mediatemplate, _m);
        });
        $(".col-left .list-video").html(html);
    });
    
    /* Search Media with left column form */
    
    $(".col-left input").on("keyup change input paste", function() {
        var val = $(this).val();
        if (val) {
            var find = IriSP.Model.regexpFromTextOrArray(val, true),
                replace = IriSP.Model.regexpFromTextOrArray(val, false);
        }
        $(".col-left .item-video").each(function() {
            var li = $(this),
                title = $(this).find(".title-video"),
                titletext = title.text();
            if (val && find.test(titletext)) {
                title.html(titletext.replace(replace, '<span style="background: yellow;">$1</span>'));
                li.show();
            } else {
                title.text(titletext);
                if (val) {
                    li.hide();
                } else {
                    li.show();
                }
            }
        })
    });
    
    /* Slider */
   
    var timeSlider = $(".Ldt-Slider");
    timeSlider.slider({
        range: "min",
        value: 0,
        min: 0,
        max: 920,
        slide: function(event, ui) {
            console.log(ui.value);
            //TODO: Slide to correct Timecode
        }
    });
    
    var timeSliderHandle = timeSlider.find('.ui-slider-handle'),
        timeSliderMaximized = false,
        timeSliderTimeoutId = false,
        timeSliderMinimizedHeight = 4,
        timeSliderMaximizedHeight = 10,
        timeSliderTimeoutDuration = 1500,
        timeTooltip = $(".Ldt-Slider-Time");
    
    timeSlider.css(calculateSliderCss(timeSliderMinimizedHeight));
    timeSliderHandle.css(calculateHandleCss(timeSliderMinimizedHeight));
    
    function timeSliderMouseOver() {
        if (timeSliderTimeoutId) {
            window.clearTimeout(timeSliderTimeoutId);
            timeSliderTimeoutId = false;
        }
        if (!timeSliderMaximized) {
           timeSliderAnimateToHeight(timeSliderMaximizedHeight);
           timeSliderMaximized = true;
        }
    }
    
    function timeSliderMouseOut() {
        timeTooltip.hide();
        if (timeSliderTimeoutId) {
            clearTimeout(timeSliderTimeoutId);
            timeSliderTimeoutId = false;
        }
        timeSliderTimeoutId = setTimeout(function() {
            if (timeSliderMaximized) {
                timeSliderAnimateToHeight(timeSliderMinimizedHeight);
                timeSliderMaximized = false;
            }
            timeSliderTimeoutId = false;
        }, timeSliderTimeoutDuration);
    }
    
    timeSlider
        .mouseover(function() {
            timeTooltip.show();
            timeSliderMouseOver();
        })
        .mouseout(timeSliderMouseOut)
        .mousemove(function(_e) {
            var _x = _e.pageX - timeSlider.offset().left,
                _t = new IriSP.Model.Time(); // _this.media.duration * _x / _this.width
            timeTooltip.text(_t.toString()).css("left",_x);
        });
    
    $(".Ldt-Ctrl").mouseover(timeSliderMouseOver).mouseout(timeSliderMouseOut);
    
    function timeSliderAnimateToHeight(_height) {
        timeSlider.stop().animate(
            calculateSliderCss(_height),
            500,
            function() {
                IriSP.jQuery(this).css("overflow","visible");
            });
        timeSliderHandle.stop().animate(
            calculateHandleCss(_height),
            500,
            function() {
                IriSP.jQuery(this).css("overflow","visible");
            });
    }

    function calculateSliderCss(_size) {
        return {
            height: _size + "px",
            "margin-top": (timeSliderMinimizedHeight - _size) + "px"
        };
    }

    function calculateHandleCss(_size) {
        return {
            height: (2 + _size) + "px",
            width: (2 + _size) + "px",
            "margin-left": -Math.ceil(2 + _size / 2) + "px" 
        }
    }
    
    /* Controller Widget */
   
    var volBlock = $(".Ldt-Ctrl-Volume-Control");
    $('.Ldt-Ctrl-Sound')
        .click(function(){}) //TODO: Add Mute Handler
        .mouseover(function() {
            volBlock.show();
        })
        .mouseout(function() {
            volBlock.hide();
        });
    volBlock.mouseover(function() {
        volBlock.show();
    }).mouseout(function() {
        volBlock.hide();
    });
    
    var volBar = $(".Ldt-Ctrl-Volume-Bar");
    volBar.slider({
        slide: function(event, ui) {
            volBar.attr("title",'Volume : ' + ui.value + '%');
            //_this.media.setVolume(ui.value / 100);
        },
        stop: function() {
            // IriSP.Widgets.Controller.prototype.volumeUpdater
        }
    });
    
    /* Set current Media */
    var currentMedia;
    
    function setMedia(mediaid) {
        currentMedia = project.getElement(mediaid);
        if (currentMedia.elementType == "media") {
            $("video").hide();
            var currentvideo = $('video[data-media-id="' + mediaid + '"]');
            console.log(currentvideo);
        }
    }
    
    function addMediaPlayer(media) {
        
    }
    /* Click on media items */
   
    $(".col-left").on("click", ".item-video", function() {
        setMedia($(this).attr("data-media-id"));
    });
    
    /* Click on Tabs */
    
    function showSegmentation() {
        $(".col-middle").removeClass("empty-mode pvw-mode").addClass("segment-mode");
        return false;
    }
    function showPreview() {
        $(".col-middle").removeClass("empty-mode segment-mode").addClass("pvw-mode");
        return false;
    }
    
    $(".tab-segment").click(showSegmentation);
    $(".tab-pvw").click(showPreview);
    
    function disableMoveItemVideo() {
        $(".organize-segments .top, .organize-segments .bottom").removeClass("disable");
        $(".organize-segments .item-video:last-child .bottom, .organize-segments .item-video:first-child .top").addClass("disable");
    }
    
    $(".organize-segments").sortable({
        stop : function(){
            disableMoveItemVideo();
        }
    });
    
    $(".organize-segments .top").click(function(e){
        var currentItem = $(this).parents(".item-video");
        currentItem.insertBefore(currentItem.prev());
        disableMoveItemVideo();
    });
    
    $(".organize-segments .bottom").click(function(e){
        var currentItem = $(this).parents(".item-video");
        currentItem.insertAfter(currentItem.next());
        disableMoveItemVideo();
    });
    
}

$(function() {
    var hashcut = new IriSP.Hashcut();
});
