IriSP.mediaplayer = function(options) {
    
    var directory = new IriSP.Model.Directory(),
        content = directory.remoteSource({
            url: IriSP.endpoints.content + options.id,
            serializer: IriSP.serializers.content
        }),
        apidirectory = new IriSP.Model.Directory(),
        segmenttemplate = _.template(
            '<div class="media-segment" data-mashup-id="<%= annotation.project_id %>">'
            + '<div class="media-segment-section" style="left:<%= left %>px; width:<%= width %>px; background:<%= color %>; top: <%= top %>px;" data-segment-id="<%= annotation.id %>"></div>'
            + '<div class="popin media-segment-popin" style="left:<%= popleft %>px; top: <%= 5+top %>px;"><div style="left:<%= pointerpos %>px;" class="pointer"></div><div class="popin-content">'
            + '<h3 class="segment-title"><%= annotation.title %></h3>'
            + '<p><%= annotation.description %></p><% if (annotation.keywords.length) { print("<p><strong>" + gettext("Tags:") + "</strong> " + annotation.keywords.join(", ") + "</p>"); } %>'
            + '<p><%= gettext("From:") %> <span><%= annotation.begin.toString() %></span> <%= gettext("to:") %> <span><%= annotation.end.toString() %></span> (<%= gettext("duration:") %> <span><%= annotation.getDuration().toString() %></span>)</p>'
            + '<p class="mashup-link"><%= gettext("From hashcut:") %> <a href="<%= IriSP.endpoints.hashcut_page.replace("__PROJECT_ID__", annotation.project_id) %>"></a></p>'
            + '</div></div></div>'
        ),
        segmentlisttemplate = _.template(
            '<div class="media-segment-list" style="height: <%= height %>px"><div class="media-segment-list-inner"></div><%= segments %><div class="frise-position"></div></div>'
        ),
        projtemplate = _.template(
            '<li class="item-video mashup" data-mashup-id="<%= ldt_id %>">'
            + '<a href="<%= IriSP.endpoints.hashcut_page.replace("__PROJECT_ID__", ldt_id) %>"><img class="thumbnail" alt="<%= title %>" src="<%= image %>"></a><div class="video-info">'
            + '<h3 class="title-video"><a href="<%= IriSP.endpoints.hashcut_page.replace("__PROJECT_ID__", ldt_id) %>"><%= title %></a></h3><p class="description"><%= description %></p>'
            + '</p></div></li>'
        ),
        media;
    
    function mediaSegmentList(_annotations) {
        var html = '',
            k = $(".Ldt-Slider").width() / media.duration,
            lines = [];
        _(_annotations).each(function(_a, i) {
            var pos = k * (_a.begin + _a.end) / 2,
                corrpos = Math.max(106, Math.min(516, pos)),
                line = IriSP._(lines).find(function(line) {
                    return !IriSP._(line.annotations).find(function(ann) {
                        return ann.begin < _a.end && ann.end > _a.begin;
                    });
                });
            if (!line) {
                line = { index: lines.length, annotations: []};
                lines.push(line); 
            }
            line.annotations.push(_a);
            vizdata = {
                annotation : _a,
                popleft : corrpos,
                left : k * _a.begin,
                width : k * _a.getDuration(),
                height: 8,
                top: 8 * line.index,
                pointerpos : (pos - corrpos),
                color: IriSP.vizcolors[i % IriSP.vizcolors.length]
            };
            html += segmenttemplate(vizdata);
        });
        return segmentlisttemplate({
            height: 8 * lines.length,
            segments: html
        });
    }
    
    content.onLoad(function() {
        
        IriSP.mashupcore(content, new IriSP.Model.Mashup(false, content));
        
        media = content.getMedias()[0];
        
        apidirectory.remoteSource({
            url: IriSP.endpoints.segment,
            url_params: {
                iri_id: options.id,
                limit: 0
            },
            serializer: IriSP.serializers.segmentapi
        }).onLoad(function() {
            var medias = this.getMedias(),
                annotations = this.getAnnotations(),
                projlist = {};
            $(".media-segments").html(mediaSegmentList(annotations));
            annotations.forEach(function(a) {
                projlist[a.project_id] = 1 + (projlist[a.project_id] || 0);
            });
            var projkeys = _(projlist)
                .chain()
                .keys()
                .sortBy(function(v) {
                    return - projlist[v];
                })
                .first(8)
                .value();
            $.ajax({
                url: IriSP.endpoints.project,
                dataType: "json",
                data: {
                    format: "json",
                    ldt_id__in: projkeys
                },
                traditional: true,
                success: function(data) {
                    var proj = _(data.objects)
                        .filter(function(p) {
                            return /<inst/gm.test(p.ldt);
                        });
                    _(proj).each(function(p) {
                        $(".media-segment[data-mashup-id='" + p.ldt_id + "']").each(function() {
                            $(this)
                                .find(".mashup-link").show()
                                .find("a").text(p.title);
                        });
                    });
                    var html = _(proj)
                        .chain()
                        .sortBy(function(p) {
                            return - projlist[p.ldt_id];
                        })
                        .map(projtemplate)
                        .value()
                        .join("");
                    $(".list-video").html(html);
                }
            });
        });
    
        content.trigger("set-current", media);
        
        $(".info-duration td").text(media.duration.toString());
        $(".info-description td").text(media.description);
        $(".info-tags td").text(media.keywords);
        
    });
    
    $(".media-segments").on("mouseover", ".media-segment", function() {
        var el = $(this);
        el.find(".media-segment-popin").show();
        var pid = el.attr("data-mashup-id");
        $(".item-video[data-mashup-id='" + pid + "']").addClass("active");
    }).on("mouseout", ".media-segment", function() {
        $(this).find(".media-segment-popin").hide();
        $(".item-video").removeClass("active");
    }).on("click", ".media-segment-section", function() {
        var sid = $(this).attr("data-segment-id"),
            s = apidirectory.getElement(sid);
        media.setCurrentTime(s.begin);
    });
    
    $(".list-video").on("mouseover", ".item-video", function() {
        var pid = $(this).attr("data-mashup-id");
        $(".media-segment[data-mashup-id='" + pid + "']").addClass("active");
    }).on("mouseout", ".item-video", function() {
        $(".media-segment").removeClass("active");
    });
};

/* END mediaplayer.js */

