IriSP.mashupplayer = function(options) {
    
    var directory = new IriSP.Model.Directory(),
        project = directory.remoteSource({
            url: IriSP.endpoints.ldt.replace('__PROJECT_ID__', options.id),
            serializer: IriSP.serializers.ldt
        }),
        apidirectory = new IriSP.Model.Directory(),
        mashup,
        mediatemplate = _.template('<li class="item-video media" data-media-id="<%= media.id %>">'
            + '<a href="<%= IriSP.endpoints.media_page.replace("__CONTENT_ID__", media.id) %>"><img class="thumbnail" alt="<%= media.title %>" src="<%= media.thumbnail %>"></a><div class="video-info">'
            + '<h3 class="title-video"><a href="<%= IriSP.endpoints.media_page.replace("__CONTENT_ID__", media.id) %>"><%= media.title %></a></h3><p class="description"><%= media.description %></p>'
            + '<p class="time-length">Durée : <span><%= media.duration.toString() %></span></p><div class="frise">'
            + '<div class="frise-overflow"><div class="frise-segments"><%= segments %></div></div></div></div></li>');
        segmenttemplate = _.template('<div style="background-color:<%= annotation.color %>; left:<%= left %>%; width: <%= width %>%;"'
            + ' class="frise-segment annotation" data-segment-id="<%= annotation.id %>" title="<%= annotation.title %>"></div>');
    
    project.onLoad(function() {
        mashup = project.getMashups()[0];
        IriSP.mashupcore(project, mashup);
        project.trigger("set-current",mashup);
        
        $(".info-duration td").text(mashup.duration.toString());
        
        $(".info-description td").text(mashup.description);
        
        mashup.getMedias().forEach(function(media) {
            apidirectory.remoteSource({
                url: IriSP.endpoints.content + media.id,
                serializer: IriSP.serializers.content
            }).onLoad(function() {
                var m = apidirectory.getElement(media.id);
                if (m) {
                    media.thumbnail = m.thumbnail;
                }
                var segments = mashup.segments.filter(function(segment) {
                    return segment.getMedia() === media;
                });
                var segmentshtml = '', k = media.duration ? (100 / media.duration) : 0;
                segments.forEach(function(segment) {
                    var vizdata = {
                        annotation: segment.annotation,
                        left: k * segment.annotation.begin,
                        width: k * segment.annotation.getDuration()
                    };
                    segmentshtml += segmenttemplate(vizdata);
                });
                var mediadata = {
                    media: media,
                    segments: segmentshtml
                };
                
                $(".list-video").append(mediatemplate(mediadata));
            });
        });
        
        
        project.on("mouseover-annotation", function(annotation) {
            var mediaid = annotation.getMedia().id;
            $(".media").removeClass("active");
            $(".media[data-media-id='" + mediaid + "']").addClass("active");
        });
        
        project.on("mouseout-annotation", function(annotation) {
            $(".media").removeClass("active");
            if (mashup.currentMedia) {
                var mediaid = mashup.currentMedia.id;
                $(".media[data-media-id='" + mediaid + "']").addClass("active");
            }
        });
        
        $(".list-video")
        .on("mouseover", ".frise-segment", function() {
            project.trigger("mouseover-annotation", project.getElement($(this).attr("data-segment-id")));
        })
        .on("click", ".frise-segment", function() {
            project.trigger("click-annotation", project.getElement($(this).attr("data-segment-id")));
        })
        .on("mouseover", ".item-video", function() {
            $(".media").removeClass("active");
        })
        .on("mouseout", ".item-video", function() {
            project.trigger("mouseout-annotation");
        });
        
        $(".mashup-frise")
        .click(function(evt) {
            if (!mashup.duration.milliseconds) {
                return;
            }
            var el = $(this), t = ( evt.pageX - el.offset().left ) * mashup.duration / el.width(), segment = mashup.getAnnotationAtTime(t);
            if (segment) {
                project.trigger("click-annotation", segment.annotation);
            }
        });
        
        mashup.play();
        
    });
};

/* END mashupplayer.js */
