IriSP.player = function(options) {
    
    var directory = new IriSP.Model.Directory(),
        project = directory.remoteSource({
            url: options.url,
            serializer: IriSP.serializers.ldt
        }),
        mashup,
        mediatemplate = _.template('<li class="item-video media" data-media-id="<%= media.id %>">'
            + '<a href="#"><img alt="<%= media.title %>" src="<%= media.thumbnail %>"></a><div class="video-info">'
            + '<h3 class="title-video"><a href="#"><%= media.title %></a></h3><p class="description"><%= media.description %></p>'
            + '<p class="time-length">Durée : <span><%= media.duration.toString() %></span></p><div class="frise">'
            + '<div class="frise-overflow"><div class="frise-segments"><%= segments %></div></div></div></div></li>');
        segmenttemplate = _.template('<div style="background-color:<%= annotation.color %>; left:<%= left %>%; width: <%= width %>%;"'
            + ' class="frise-segment annotation" data-segment-id="<%= annotation.id %>" title="<%= annotation.title %>"></div>')
    
    project.onLoad(function() {
        mashup = project.getMashups()[0];
        IriSP.mashupcore(project, mashup);
        project.trigger("set-current",mashup);
        
        $(".info-title a").text(mashup.title);
        $(".info-duration td").text(mashup.duration.toString());
        $(".info-author a").text(mashup.creator);
        $(".info-description td").text(mashup.description);
        
        var html = '';
        mashup.getMedias().forEach(function(media) {
            var segments = mashup.segments.filter(function(segment) {
                return segment.getMedia() === media;
            });
            var segmentshtml = '', k = media.duration ? (100 / media.duration) : 0;
            segments.forEach(function(segment) {
                var vizdata = {
                    annotation: segment.annotation,
                    left: k * segment.annotation.begin,
                    width: k * segment.annotation.getDuration()
                }
                segmentshtml += segmenttemplate(vizdata);
            });
            var mediadata = {
                media: media,
                segments: segmentshtml
            }
            html += mediatemplate(mediadata);
        });
        
        $(".list-video").html(html);
        
        project.on("mouseover-annotation", function(annotation) {
            var mediaid = annotation.getMedia().id;
            $(".media").removeClass("active");
            $(".media[data-media-id='" + mediaid + "']").addClass("active");
        });
        
        project.on("mouseout-annotation", function(annotation) {
            $(".media").removeClass("active");
            var mediaid = mashup.currentMedia.id;
            $(".media[data-media-id='" + mediaid + "']").addClass("active");
        });
        
        $(".list-video .frise-segment")
        .mouseover(function() {
            project.trigger("mouseover-annotation", project.getElement($(this).attr("data-segment-id")));
        })
        .click(function() {
            project.trigger("click-annotation", project.getElement($(this).attr("data-segment-id")));
        });
        
        $(".item-video")
        .mouseover(function() {
            $(".media").removeClass("active");
        })
        .mouseout(function() {
            project.trigger("mouseout-annotation");
        })
        
        
    });
}
