from django.core.exceptions import ImproperlyConfigured
from django.http import HttpResponseNotFound
from django.views.generic.base import View, TemplateResponseMixin
from ldt.ldt_utils.models import Project
import logging


class MashupHome(TemplateResponseMixin, View):
    
    # iri = default brand name
    branding = "iri"
    template_suffix = "mashup_home.html"
    template_name = "iri_mashup_home.html"
    
    def get_template_names(self):
        """
        Return a list of template names to be used for the request. Must return
        a list. May not be called if get_template is overridden.
        """
        try:
            names = super(MashupHome, self).get_template_names()
        except ImproperlyConfigured:
            raise ImproperlyConfigured("Class MashupHome requires either a definition of 'template_name'")

        # the branding template is supposed to override the default template. So we insert instead of append
        if self.branding and self.branding != "":
            names.insert(0,"%s_%s" % (self.branding, self.template_suffix))
        
        return names
    
    
    def get(self, request, branding=None, **kwargs):
        if branding and branding!="":
            self.branding = branding
        projects = Project.safe_objects.all()[:10]
        p1 = projects[0]
        p2 = projects[1]
        projects = projects[2:]
        context = {"branding":self.branding, "projects":projects, "p1":p1, "p2":p2}
        return self.render_to_response(context)
    


class MashupEdit(TemplateResponseMixin, View):
    
    # iri = default brand name
    branding = "iri"
    template_suffix = "mashup_edit.html"
    template_name = "iri_mashup_edit.html"
    
    def get_template_names(self):
        """
        Return a list of template names to be used for the request. Must return
        a list. May not be called if get_template is overridden.
        """
        try:
            names = super(MashupEdit, self).get_template_names()
        except ImproperlyConfigured:
            raise ImproperlyConfigured("Class MashupEdit requires either a definition of 'template_name'")

        # the branding template is supposed to override the default template. So we insert instead of append
        if self.branding and self.branding != "":
            names.insert(0,"%s_%s" % (self.branding, self.template_suffix))
        
        return names
    
    def get(self, request, branding="iri", **kwargs):
        logging.debug("COUCOU")
        self.branding = branding
        context = {"branding":self.branding}
        return self.render_to_response(context)
    


class MashupHashcut(TemplateResponseMixin, View):
    
    # iri = default brand name
    branding = "iri"
    template_suffix = "mashup_hashcut.html"
    template_name = "iri_mashup_hashcut.html"
    
    def get_template_names(self):
        """
        Return a list of template names to be used for the request. Must return
        a list. May not be called if get_template is overridden.
        """
        try:
            names = super(MashupHashcut, self).get_template_names()
        except ImproperlyConfigured:
            raise ImproperlyConfigured("Class MashupHashcut requires either a definition of 'template_name'")

        # the branding template is supposed to override the default template. So we insert instead of append
        if self.branding and self.branding != "":
            names.insert(0,"%s_%s" % (self.branding, self.template_suffix))
        
        return names
    
    def get(self, request, branding="iri", ldt_id=None, **kwargs):
        self.branding = branding
        if not ldt_id:
            return HttpResponseNotFound("A project id must be given.")
        context = {"branding":self.branding, "ldt_id":ldt_id}
        return self.render_to_response(context)
    
    
    
    
    
    
    