(function() {
    var Hashcut = function() {
        var directory = new IriSP.Model.Directory(),
            project = directory.remoteSource({
                url: "data/bpidata.json",
                serializer: IriSP.serializers.medialist
            }),
            mediatemplate = '<li class="item-video"><img src="{{thumbnail}}" alt="{{title}}" />'
                + '<span class="video-info"><span class="title-video">{{title}}</span><span class="author">{{description}}</span>'
                + '<span class="time-length">Durée : <span>{{duration}}</span></span></span></li>';
        project.onLoad(function() {
            var html = '';
            project.getMedias().forEach(function(_m) {
                html += Mustache.to_html(mediatemplate, _m);
            });
            $(".col-left .list-video").html(html);
        });
        
        $(".col-left input").on("keyup change input paste", function() {
            var val = $(this).val();
            if (val) {
                var find = IriSP.Model.regexpFromTextOrArray(val, true),
                    replace = IriSP.Model.regexpFromTextOrArray(val, false);
            }
            $(".col-left .item-video").each(function() {
                var li = $(this),
                    title = $(this).find(".title-video"),
                    titletext = title.text();
                if (val && find.test(titletext)) {
                    title.html(titletext.replace(replace, '<span style="background: yellow;">$1</span>'));
                    li.show();
                } else {
                    title.text(titletext);
                    if (val) {
                        li.hide();
                    } else {
                        li.show();
                    }
                }
            })
        });
        
        $(".tab-segment").click(function() {
            $(".col-middle").removeClass("empty-mode pvw-mode").addClass("segment-mode");
            return false;
        });
        $(".tab-pvw").click(function() {
            $(".col-middle").removeClass("empty-mode segment-mode").addClass("pvw-mode");
            return false;
        });
        
        function disableMoveItemVideo() {
            $(".organize-segments .top, .organize-segments .bottom").removeClass("disable");
            $(".organize-segments .item-video:last-child .bottom, .organize-segments .item-video:first-child .top").addClass("disable");
        }
        
        $(".organize-segments").sortable({
            stop : function(){
                disableMoveItemVideo();
            }
        });
        
        $(".organize-segments .top").click(function(e){
            var currentItem = $(this).parents(".item-video");
            currentItem.insertBefore(currentItem.prev());
            disableMoveItemVideo();
        });
        
        $(".organize-segments .bottom").click(function(e){
            var currentItem = $(this).parents(".item-video");
            currentItem.insertAfter(currentItem.next());
            disableMoveItemVideo();
        });
        
        
    }
    
    IriSP.Hashcut = Hashcut;
}
)();

$(function() {
    var hashcut = new IriSP.Hashcut();
});
