IriSP.player = function(options) {
    
    var directory = new IriSP.Model.Directory(),
        project = directory.remoteSource({
            url: options.url,
            serializer: IriSP.serializers.ldt
        }),
        mashup;
    
    project.onLoad(function() {
        mashup = project.getMashups()[0];
        IriSP.mashupcore(project, mashup);
        project.trigger("set-current",mashup);
        
        $(".info-title a").text(mashup.title);
        $(".info-duration td").text(mashup.duration.toString());
        $(".info-author a").text(mashup.creator);
        $(".info-description td").text(mashup.description);
        
    });
}
