from django.conf.urls.defaults import patterns, url
from hashcut.views import MashupHome, MashupEdit, MashupHashcut, MashupContent, MashupProfile, MashupAllMashups,\
    MashupCreateUser, MashupIdenticateUser

urlpatterns = patterns('',
    url(r'^jsi18n/(?P<packages>\S+?)/$', 'django.views.i18n.javascript_catalog', name='jsi18n'),
    url(r'^(?P<branding>.*)/edit/$', MashupEdit.as_view(), name="mashup_edit"),
    url(r'^(?P<branding>.*)/save/$', 'hashcut.views.save_mashup', name="mashup_save"),
    url(r'^(?P<branding>.*)/hashcut/(?P<ldt_id>.*)/$', MashupHashcut.as_view(), name="mashup_hashcut"),
    url(r'^(?P<branding>.*)/media/(?P<ctt_id>.*)/$', MashupContent.as_view(), name="mashup_content"),
    url(r'^(?P<branding>.*)/profile/(?P<username>.*)/$', MashupProfile.as_view(), name="mashup_profile"),
    url(r'^(?P<branding>.*)/all/$', MashupAllMashups.as_view(), name="mashup_all"),
    url(r'^(?P<branding>.*)/createuser/$', MashupCreateUser.as_view(), name="mashup_create_user"),
    url(r'^(?P<branding>.*)/iduser/$', MashupIdenticateUser.as_view(), name="mashup_identicate_user"),
    url(r'^(?P<branding>.*)/$', MashupHome.as_view(), name="mashup_home"),
    url(r'^$', MashupHome.as_view()),
)
