#! /usr/bin/env python

import sys, os, os.path, time, tempfile, uuid

sys.path.append(os.path.dirname(os.path.abspath(__file__))+"/../web/")

from django.core.management import setup_environ
from franceculture import settings

setup_environ(settings)

from franceculture.settings import *

from ldt.ldt_utils.models import Content, Media


from django.db import connection, transaction

transaction.enter_transaction_management()

try:
    cursor = connection.cursor()
    
    # Data retrieval operation - no commit required
    cursor.execute("SELECT id,external_id, videopath, src FROM ldt_utils_content", None)
    
    
    for row in cursor.fetchall():
        new_media = Media(external_id = row[1], videopath=row[2], src=row[3])
        new_media.save()
        
        content = Content.objects.get(id=row[0])
        content.media_obj = new_media
        
        content.save()
except Exception as inst:
    transaction.rollback()
else:
    transaction.commit()
finally:
    transaction.leave_transaction_management()