using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using Microsoft.Surface;
using Microsoft.Surface.Presentation;
using Microsoft.Surface.Presentation.Controls;
using System.Windows.Controls.Primitives;

namespace SliderTest
{
    /// <summary>
    /// Interaction logic for SurfaceWindow1.xaml
    /// </summary>
    public partial class SurfaceWindow1 : SurfaceWindow
    {
        DispatcherTimer timer;
        bool isDragging=false;
        bool finishedDragging = false;

        /// <summary>
        /// Default constructor.
        /// </summary>
        public SurfaceWindow1()
        {
            InitializeComponent();
            initmedia();
            // Add handlers for Application activation events
            AddActivationHandlers();
        }

        /// <summary>
        /// Occurs when the window is about to close. 
        /// </summary>
        /// <param name="e"></param>
        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // Remove handlers for Application activation events
            RemoveActivationHandlers();
        }

        /// <summary>
        /// Adds handlers for Application activation events.
        /// </summary>
        private void AddActivationHandlers()
        {
            // Subscribe to surface application activation events
            ApplicationLauncher.ApplicationActivated += OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed += OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated += OnApplicationDeactivated;
        }

        /// <summary>
        /// Removes handlers for Application activation events.
        /// </summary>
        private void RemoveActivationHandlers()
        {
            // Unsubscribe from surface application activation events
            ApplicationLauncher.ApplicationActivated -= OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed -= OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated -= OnApplicationDeactivated;
        }

        /// <summary>
        /// This is called when application has been activated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationActivated(object sender, EventArgs e)
        {
            //TODO: enable audio, animations here
        }

        /// <summary>
        /// This is called when application is in preview mode.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationPreviewed(object sender, EventArgs e)
        {
            //TODO: Disable audio here if it is enabled

            //TODO: optionally enable animations here
        }

        /// <summary>
        ///  This is called when application has been deactivated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationDeactivated(object sender, EventArgs e)
        {
            //TODO: disable audio, animations here
        }

        #region Media

        private void initmedia()
        {
            media.UnloadedBehavior = MediaState.Manual;
            media.LoadedBehavior = MediaState.Manual;
            media.ScrubbingEnabled = true;
        }

        private void media_MediaOpened(object sender, RoutedEventArgs e)
        {
            initslider();
            timer.Start();
        }
        #endregion

        #region Timer
        private void initTimer()
        {
            timer = new DispatcherTimer();
            timer.Interval = new TimeSpan(0, 0, 0, 0, 100); 
            timer.Tick += new EventHandler(timer_Tick);
        }

        void timer_Tick(object sender, EventArgs e)
        {
            if (!isDragging)
            {
                slider.Value = media.Position.TotalMilliseconds;
            }
            if (finishedDragging)
            {
                int SliderValue = (int)slider.Value;
                TimeSpan ts = new TimeSpan(0, 0, 0, 0, SliderValue);
                media.Position = ts;
                media.Play();
                isDragging = false;
                finishedDragging = false;
            }
        }

        #endregion

        #region Slider

        private void initslider()
        {
            slider.Maximum = media.NaturalDuration.TimeSpan.TotalMilliseconds;
        }

        //works ^^
        private void sliderPosition_DragStarted(
            object sender, DragStartedEventArgs e)
        {
            isDragging = true;
            media.Pause();
        }
        //works ^^
        private void sliderPosition_DragCompleted(
            object sender, DragCompletedEventArgs e)
        {
            finishedDragging = true;
        }
        #endregion
       

        private void buttonPlay_Click(object sender, RoutedEventArgs e)
        {
            media.Play();
        }

        private void SurfaceWindow_Activated(object sender, EventArgs e)
        {
            initTimer();
        }


        private void surfacebuttonPlay_ContactDown(object sender, ContactEventArgs e)
        {
            media.Play();
        }
        private void surfacebuttonPlay_Click(object sender, RoutedEventArgs e)
        {
                media.Play();
        }

        

    }
}