﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;

namespace FingersDance.Data
{
    public class DataDictionary
    {
        Dictionary<int, List<Color>> _Data = new Dictionary<int, List<Color>>();

        public DataDictionary()
        {
            if (_Data == null)
                _Data = new Dictionary<int, List<Color>>();
        }

        public void AddAnnotation(Annotation annotation)
        {
            try
            {
                //  Recherche de l'élément qui précède le TC de début
                List<Color> temp = new List<Color>();
                int value = 0;
                for (int i = (int)annotation.TcBegin; i >= 0; i--)
                    if (_Data.ContainsKey(i))
                    {
                        value = i;
                        i = -1;
                    }

                //  Ajout des couleurs de l'élément qui précède
                if (!_Data.ContainsKey((int)annotation.TcBegin))
                {
                    if (_Data.ContainsKey(value))
                        foreach (Color elt in _Data[value])
                            temp.Add(elt);
                    _Data.Add((int)annotation.TcBegin, temp);
                }

                //  Ajout de la couleur à tous les éléments entre le début et la fin de l'annotation
                foreach (KeyValuePair<int, List<Color>> elt in _Data)
                    if (elt.Key >= (int)annotation.TcBegin && elt.Key < (int)(annotation.TcBegin + annotation.Dur) && !elt.Value.Contains(annotation.Color))
                        elt.Value.Add(annotation.Color);

                //  Vérification que début et fin correspondent à deux éléments distincts et ajout de la fin de l'annotation si nécessaire (tc de fin inexistant)
                if (((int)annotation.TcBegin) != ((int)(annotation.TcBegin + annotation.Dur)))
                {
                    temp = new List<Color>();
                    if (!_Data.ContainsKey((int)(annotation.TcBegin + annotation.Dur)))
                    {
                        for (int i = (int)(annotation.TcBegin + annotation.Dur); i >= 0; i--)
                            if (_Data.ContainsKey(i))
                            {
                                value = i;
                                i = -1;
                            }
                        if (_Data.ContainsKey(value))
                            foreach (Color elt in _Data[value])
                                temp.Add(elt);
                        temp.Remove(annotation.Color);
                        _Data.Add((int)(annotation.TcBegin + annotation.Dur), temp);
                    }
                }
                else if (!_Data.ContainsKey((int)(annotation.TcBegin + 1)))
                {
                    temp = new List<Color>();
                    foreach (Color elt in _Data[(int)annotation.TcBegin])
                        temp.Add(elt);
                    _Data.Add((int)(annotation.TcBegin + 1), temp);
                }
            }
            catch { }
        }

        public void RemoveAnnotation(Annotation annotation)
        {
            try
            {
                //  Suppression de la couleur à tous les éléments entre le début et la fin de l'annotation
                foreach (KeyValuePair<int, List<Color>> elt in _Data)
                    if (elt.Key >= (int)annotation.TcBegin && elt.Key < (int)(annotation.TcBegin + annotation.Dur) && elt.Value.Contains(annotation.Color))
                        elt.Value.Remove(annotation.Color);
            }
            catch { }
        }

        public List<Color> GetColors(int TC)
        {
            try
            {
                for (int i = TC; i >= 0; i--)
                    if (_Data.ContainsKey(i))
                        return _Data[i];
                return new List<Color>();
            }
            catch (Exception)
            {
                return new List<Color>();
            }
        }
    }
}
