﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Surface;
using Microsoft.Surface.Presentation;
using Microsoft.Surface.Presentation.Controls;
using System.ComponentModel;

namespace FingersDance.Control.UserPanel
{
    /// <summary>
    /// Interaction logic for TagVisuSoundControl.xaml
    /// </summary>
    public partial class TagVisuSoundControl : TagVisualization
    {
        //Base sound
        int sound =5;
        int lastlevel = 0;
        //Vars For Debug
        List<int> listniveau = new List<int>();
        List<int> listsound = new List<int>();

        public TagVisuSoundControl()
        {
            InitializeComponent();
            lastlevel = 1;
            TagVisuSoundLevelUpdate(0);
            volumeModel.Visibility = Visibility.Hidden;
            #if DEBUG
            volumeModel.Visibility = Visibility.Visible;
            #endif
        }

        private void TagVisuSoundControl_Loaded(object sender, RoutedEventArgs e)
        {
            //TODO: customize TagVisuSoundControl's UI based on this.VisualizedTag here
           
        }

        //This Method Make the different elipses visible in accordance to the viriable "niveau"
        public int TagVisuSoundLevelUpdate(int niveau)
        {
            int nbelipsesvisible = -1;
           int tempsound = 0;
           //--DEBUG listniveau.Add(niveau);
           if (Math.Abs(lastlevel - niveau) == 1)
           {
               lastlevel = niveau;
               tempsound = sound + niveau;
               if (tempsound > -1 && tempsound < 11)
               {
                   nbelipsesvisible = 0;
                   //--DEBUG listsound.Add(tempsound);
                   for (int i = 1; i <= tempsound; i++)
                   {
                       switch (i)
                       {
                           case 1:
                               elipse01.Visibility = Visibility.Visible;
                               nbelipsesvisible++;
                               break;
                           case 2:
                               elipse02.Visibility = Visibility.Visible;
                               nbelipsesvisible++;
                               break;
                           case 3:
                               elipse03.Visibility = Visibility.Visible;
                               nbelipsesvisible++;
                               break;
                           case 4:
                               elipse04.Visibility = Visibility.Visible;
                               nbelipsesvisible++;
                               break;
                           case 5:
                               elipse05.Visibility = Visibility.Visible;
                               nbelipsesvisible++;
                               break;
                           case 6:
                               elipse06.Visibility = Visibility.Visible;
                               nbelipsesvisible++;
                               break;
                           case 7:
                               elipse07.Visibility = Visibility.Visible;
                               nbelipsesvisible++;
                               break;
                           case 8:
                               elipse08.Visibility = Visibility.Visible;
                               nbelipsesvisible++;
                               break;
                           case 9:
                               elipse09.Visibility = Visibility.Visible;
                               nbelipsesvisible++;
                               break;
                           case 10:
                               elipse10.Visibility = Visibility.Visible;
                               nbelipsesvisible++;
                               break;
                       }
                   }
                   for (int i = tempsound + 1; i < 11; i++)
                   {
                       switch (i)
                       {
                           case 1:
                               elipse01.Visibility = Visibility.Hidden;
                               break;
                           case 2:
                               elipse02.Visibility = Visibility.Hidden;
                               break;
                           case 3:
                               elipse03.Visibility = Visibility.Hidden;
                               break;
                           case 4:
                               elipse04.Visibility = Visibility.Hidden;
                               break;
                           case 5:
                               elipse05.Visibility = Visibility.Hidden;
                               break;
                           case 6:
                               elipse06.Visibility = Visibility.Hidden;
                               break;
                           case 7:
                               elipse07.Visibility = Visibility.Hidden;
                               break;
                           case 8:
                               elipse08.Visibility = Visibility.Hidden;
                               break;
                           case 9:
                               elipse09.Visibility = Visibility.Hidden;
                               break;
                           case 10:
                               elipse10.Visibility = Visibility.Hidden;
                               break;
                       }
                   }
               }
           }
           return nbelipsesvisible;
        }
    }

    
}
