﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;

namespace FingersDance.Control.SyncSource
{
    public enum SyncSourceState
    {
        Playing,
        Paused,
        Stopped
    }

    public class SyncSourceEventArg : RoutedEventArgs
    {
        public SyncSourceState OrignalState { get; set; }
        public SyncSourceState NewState { get; set; }
    }

    public delegate void SyncSourceEventHandler(Object source, SyncSourceEventArg e);

    public interface ISyncSource
    {
        void Play();
        void Pause();
        void Stop();
        SyncSourceState State { get; set; }
        event SyncSourceEventHandler CurrentStateChanged;
    }
}
