﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using Microsoft.Surface;
using Microsoft.Surface.Presentation;
using Microsoft.Surface.Presentation.Controls;
using System.IO;
using System.Xml.Serialization;

namespace TestMenu
{
    /// <summary>
    /// Interaction logic for SurfaceWindow1.xaml
    /// </summary>
    public partial class SurfaceWindow1 : SurfaceWindow
    {
        /// <summary>
        /// Default constructor.
        /// </summary>

        FingersDance.ActionFactory.ActionFactory _Factory = new FingersDance.ActionFactory.ActionFactory();
        FingersDance.Debug.SurfaceWindow1 Debug = new FingersDance.Debug.SurfaceWindow1();

        public SurfaceWindow1()
        {
            InitializeComponent();

            StreamReader reader = null;
            reader = new StreamReader("../../test.xml");
            XmlSerializer serializer = new XmlSerializer(typeof(Menu));
            Menu temp = (Menu)serializer.Deserialize(reader);
            foreach (Item elt in temp.Items)
                try
                {
                    MyMenu.Items.Add(CreateMenuItem(elt));
                }
                catch (Exception) { }
            reader.Close();

            // Add handlers for Application activation events
            AddActivationHandlers();
        }

        public SurfaceMenuItem CreateMenuItem(Item item)
        {
            try
            {
                SurfaceMenuItem MItem = new SurfaceMenuItem();
                MItem.Header = item.Name;
                MItem.Visibility = Visibility.Visible;
                if (!item.Action.Equals(""))
                {
                    MItem.ContactDown += GenerateAction;
                    MItem.Click += GenerateAction;
                }
                foreach (Item elt in item.Items)
                    try
                    {
                        MItem.Items.Add(CreateMenuItem(elt));
                    }
                    catch (Exception) { }
                return MItem;
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        private void GenerateAction(Object sender, EventArgs Event)
        {
            try
            {
                FingersDance.Actions.ActionBase action = _Factory.GetAction("TestMenu.Action" + ((SurfaceMenuItem)sender).Header, "Tu as cliqué sur " + ((SurfaceMenuItem)sender).Header);
                if (action != null)
                    action.Execute();
            }
            catch (Exception) { }
        }

        /// <summary>
        /// Occurs when the window is about to close. 
        /// </summary>
        /// <param name="e"></param>
        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // Remove handlers for Application activation events
            RemoveActivationHandlers();
        }

        /// <summary>
        /// Adds handlers for Application activation events.
        /// </summary>
        private void AddActivationHandlers()
        {
            // Subscribe to surface application activation events
            ApplicationLauncher.ApplicationActivated += OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed += OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated += OnApplicationDeactivated;
        }

        /// <summary>
        /// Removes handlers for Application activation events.
        /// </summary>
        private void RemoveActivationHandlers()
        {
            // Unsubscribe from surface application activation events
            ApplicationLauncher.ApplicationActivated -= OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed -= OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated -= OnApplicationDeactivated;
        }

        /// <summary>
        /// This is called when application has been activated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationActivated(object sender, EventArgs e)
        {
            //TODO: enable audio, animations here
        }

        /// <summary>
        /// This is called when application is in preview mode.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationPreviewed(object sender, EventArgs e)
        {
            //TODO: Disable audio here if it is enabled

            //TODO: optionally enable animations here
        }

        /// <summary>
        ///  This is called when application has been deactivated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationDeactivated(object sender, EventArgs e)
        {
            //TODO: disable audio, animations here
        }
    }
}