﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using System.Windows.Controls.Primitives;
using Microsoft.Surface.Presentation.Controls;
using System.Windows.Threading;

using FingersDance.Data;
using FingersDance.ViewModels;

namespace FingersDance.Control.TimeLine
{
	public partial class UserControlTimeLine
    {

        #region Variables
        private DispatcherTimer timer;
        private bool isDragging = false;
        private bool finishedDragging = false;
        #endregion

        public event EventHandler DragStarted;
        public event EventHandler DragCompleted;
        public event EventHandler TimerTick;

        private double totalmilliseconds;

        private List<Annotation> AnnotList = new List<Annotation>();
        private float AnnotWidth = 40+1;
        private CuttingViewModel CuttingVM;
        private Boolean AnnotWaiting = false;
        private float AnnotTcBegin;
        private AnnotationViewModel lastAnnotVM;

        #region Properties

        public SurfaceSlider Slider
        {
            get
            {
                return slider;
            }
            set
            {
                slider = value;
            }
        }
        
        public bool IsDragging
        {
            get
            {
                return isDragging;
            }
            set
            {
                isDragging = value;
            }
        }

        public bool FinishedDragging
        {
            get
            {
                return finishedDragging;
            }
            set
            {
                finishedDragging = value;
            }
        }

        public DispatcherTimer Timer
        {
            get
            {
                return timer;
            }
            set
            {
                timer = value;
            }
        }
        #endregion
        


        
		public UserControlTimeLine()
		{   
			this.InitializeComponent();

			// Insert code required on object creation below this point.
            
		}

        public void initslider(double totalmillisecondsPar)
        {
            totalmilliseconds = totalmillisecondsPar;
            slider.Maximum = totalmilliseconds;
            // When the timeline is resized, we catch the resize event to define TimelineView's good scale
            this.SizeChanged += new SizeChangedEventHandler(UserControlTimeLine_SizeChanged);

            // TEMP FOR DATA BINDING
            AnnotList = new List<Annotation>();
            AnnotList.Add(new Annotation(0, 10, "Axe Cam 1"));
            //annotList.Add(new Annotation(20 - (1 * annotWidth), 30, "Mvt Cam 2"));
            //annotList.Add(new Annotation(50 - (2 * annotWidth), 60, "Saut 3"));
            //annotList.Add(new Annotation(100 - (3 * annotWidth), 20, "Saut 4"));
            //annotList.Add(new Annotation(120 - (4 * annotWidth), 50, "Saut 5"));
            Cutting cut = new Cutting("titre de cutting", AnnotList);
            CuttingVM = new CuttingViewModel(cut);
            tv.DataContext = CuttingVM;

            slider_ContactTapGesture(this,null);

        }

        void UserControlTimeLine_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            // When scaleX = 1, 1 second = 1 pixel. To calculate the new scale, we take the real width in account.
            Double futurScale = this.ActualWidth / (totalmilliseconds / 1000);
            //Double futurScale = this.ActualWidth / ((totalmilliseconds<30000) ? (totalmilliseconds/10) : (totalmilliseconds / 1000)); // TEMP FOR SHORT CONTENTS
            tv.RenderTransform = new ScaleTransform(futurScale,1);
            //Console.WriteLine("futurScale = " + futurScale);
            
        }

        #region Timer
        public void initTimer()
        {
            timer = new DispatcherTimer();
            timer.Interval = new TimeSpan(0, 0, 0, 0, 100);
            timer.Tick += new EventHandler(timer_Tick);
        }

        public void timerStart()
        {
            if (timer != null)
                timer.Start();
        }
        void timer_Tick(object sender, EventArgs e)
        {
            OnTimerTick();
            if (!isDragging)
            {
                //slider.Value = media.Position.TotalMilliseconds;
            }
            if (finishedDragging)
            {
                //int SliderValue = (int)slider.Value;
                //TimeSpan ts = new TimeSpan(0, 0, 0, 0, SliderValue);
               // media.Position = ts;
               // media.Play();
               // isDragging = false;
                //finishedDragging = false;
            }
        }
        protected virtual void OnTimerTick()
        {
            if (TimerTick != null)
                TimerTick(this, new EventArgs());
        }

        #endregion

        private void sliderPosition_DragStarted(
            object sender, DragStartedEventArgs e)
        {
            isDragging = true;
            OnDragStarted();
           // media.Pause();
        }
        protected virtual void OnDragStarted()
        {
            if (DragStarted != null)
                DragStarted(this, new EventArgs());
        }

        private void sliderPosition_DragCompleted(
            object sender, DragCompletedEventArgs e)
        {
            finishedDragging = true;
            OnDragCompleted();
        }
        protected virtual void OnDragCompleted()
        {
            if (DragCompleted != null)
                DragCompleted(this, new EventArgs());
        }

        private void slider_ContactTapGesture(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            //addAnnotation();
        }

        public void addAnnotation()
        {
            // We open a new annotation
            if (CuttingVM != null && AnnotWaiting == false)
            {
                AnnotTcBegin = (float)slider.Value;
                lastAnnotVM = new AnnotationViewModel(new Annotation((AnnotTcBegin / 1000) - (CuttingVM.AnnotList.Count * AnnotWidth), 0, CuttingVM.AnnotList.Count.ToString()));
                CuttingVM.AnnotList.Add(lastAnnotVM);
                Console.WriteLine("BEGIN currentTimecode = " + (AnnotTcBegin / 1000) + ", nb = " + CuttingVM.AnnotList.Count + ", res = " + ((AnnotTcBegin / 1000) - (CuttingVM.AnnotList.Count * AnnotWidth)));
                tv.DataContext = null;
                tv.DataContext = CuttingVM;
                AnnotWaiting = true;
            }
            // We close the current opened annotation...
            else if (CuttingVM != null && AnnotWaiting == true && ((float)slider.Value>AnnotTcBegin))
            {
                // ... by setting setting the good beginning and the good duration
                float currentDuration = ((float)slider.Value - AnnotTcBegin) / 1000;
                CuttingVM.AnnotList.RemoveAt(CuttingVM.AnnotList.Count - 1);
                CuttingVM.AnnotList.Add(new AnnotationViewModel(new Annotation((AnnotTcBegin / 1000) - (CuttingVM.AnnotList.Count * AnnotWidth), currentDuration, CuttingVM.AnnotList.Count.ToString())));
                Console.WriteLine("currentTimecode = " + (AnnotTcBegin / 1000) + ", curDur = " + currentDuration + ", nb = " + CuttingVM.AnnotList.Count + ", res = " + ((AnnotTcBegin / 1000) - (CuttingVM.AnnotList.Count * AnnotWidth)));
                tv.DataContext = null;
                tv.DataContext = CuttingVM;
                AnnotWaiting = false;
            }
        }

	}
}