﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Data;

namespace FingersDance.Control.UserPanel
{
	public partial class UserControlUserPanel
	{
        #region Variables

        public event EventHandler OnSuccessAnnotation;  //Event to display ColorAnnotation from different Users        
        public int id = 0;
        public uint idcolor = 0;    //The color of the Pivot Button
        Project _Project = new Project();
        #endregion

        #region Properties
        public Project Project
        {
            get { return _Project; }
            set { _Project = value; }
        }
        #endregion

        #region Constructors
        public UserControlUserPanel()
		{
			this.InitializeComponent();

			// Insert code required on object creation below this point.
		}

        public UserControlUserPanel(int idPar, Color col, Project p, string path)
        {
            this.InitializeComponent();
            id = idPar;
            _Project = p;
            this.UserControlSyncSource.Load(path, col, _Project.Cutting);
            UserControlSyncSource.OnSuccessAnnotation+=new EventHandler(UserControlSyncSource_OnSuccessAnnotation);
        }
        #endregion

        public void PlayerPause()
        {
            UserControlSyncSource.PlayerPause();
        }


        private void UserControlSyncSource_OnSuccessAnnotation(object sender, EventArgs e)
        {
            OnSuccessAnnotation(this, new EventArgs());
        }

        public void UserControlSyncSource_DisplayAnnotation(int id, Brush b)
        {
            UserControlSyncSource.UserControlPlayer_DisplayAnnotation(id, b);
        }
	}
}