﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using System.ComponentModel;
using System.Reflection;
using System.Collections.Generic;

using Microsoft.Surface.Presentation;
using Microsoft.Surface.Presentation.Controls;
using FingersDance.Factory;
using FingersDance.Actions;
using FingersDance.Control.TimeLine;
using FingersDance.Views;
using FingersDance.ViewModels;
using GestureControl;

namespace FingersDance.Control.Player
{
	public partial class UserControlPlayer
	{
        #region Variables
        private bool isPlaying = false;
        #endregion

        public event EventHandler PlayerOpened;
        public event EventHandler PlayerStopOrPause;

        #region constructors
        public UserControlPlayer()
        {
            this.InitializeComponent();
            MediaElementVideo.LoadedBehavior = MediaState.Manual;
            MediaElementVideo.UnloadedBehavior = MediaState.Manual;
            //SAR
            //Control User Info
            usercontrolInfoUser.LabelSession.Content = "Seance Test";
            usercontrolInfoUser.LabelUser.Content = "User Test";
        }

        #endregion

        #region Properties
        public double TotalMilliseconds
        {
            get
            {
                return MediaElementVideo.NaturalDuration.TimeSpan.TotalMilliseconds;
            }
        }
        public MediaElement Player
        {
            get
            {
                return MediaElementVideo;
            }
            set
            {
                MediaElementVideo= value;
            }
        }
        #endregion


        #region Methodes

        public void initPlayer(string path)
        {
            //init player
            isPlaying = false;
            MediaElementVideo.Source = new Uri(path);
            MediaElementVideo.ScrubbingEnabled = true;
        }

        public void playerPause()
        {
            MediaElementVideo.Pause();
            if (PlayerStopOrPause != null)
                PlayerStopOrPause(false, new EventArgs());
        }
        public void playerPlay()
        {
            MediaElementVideo.Play();
            if (PlayerStopOrPause != null)
                PlayerStopOrPause(true, new EventArgs());
        }
        public void playerStop()
        {
            MediaElementVideo.Stop();
            if (PlayerStopOrPause != null)
                PlayerStopOrPause(false, new EventArgs());
        }

        public void setSound(double val)
        {
            if (((MediaElementVideo.Volume + val) < 1) && ((MediaElementVideo.Volume + val) > 0))
                MediaElementVideo.Volume += val;
            else if ((MediaElementVideo.Volume + val) > 1)
                MediaElementVideo.Volume = 1;
            else
                MediaElementVideo.Volume = 0;
        }

        public void setMute(bool b)
        {
            if (b) MediaElementVideo.IsMuted = true;
            else MediaElementVideo.IsMuted = false;
        }
        #endregion

        #region GestureEvents

        public void GestureDetected(object sender, GestureControl.GestureRoutedEventArgs e)
        {
            Console.WriteLine("gesture detected: " + e.Gesture);
            switch (e.Gesture)
            {
                case "UP":
                    //
                    usercontrolInfoUser.LabelSession.Content = "UP!";
                    break;
                case "LEFT":
                    usercontrolInfoUser.LabelSession.Content = "LEFT!";
                    break;
                case "RIGHT":
                    usercontrolInfoUser.LabelSession.Content = "RIGHT!";
                    break;
                case "DOWN":
                    usercontrolInfoUser.LabelSession.Content = "DOWN!";
                    break;
                default:
                    //this.TxtGesture.Text = e.Gesture;
                    break;
            }
        }
        #endregion

        #region Button Simple Player Actions
        private void ButtonPlayPause_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (!isPlaying)//Play
            {
                isPlaying = true;
                try
                {
                    MediaElementVideo.Play();
                    if (PlayerStopOrPause != null)
                        PlayerStopOrPause(true, new EventArgs());
                }
                catch (Exception ex) { }
            }
            else//Pause
            {
                isPlaying = false;
                try
                {
                    MediaElementVideo.Pause();
                    if (PlayerStopOrPause != null)
                        PlayerStopOrPause(false, new EventArgs());
                }
                catch (Exception exx) { }
            }

        }

        private void ButtonPlayPause_Click(object sender, RoutedEventArgs e)
        {
            if (!isPlaying)//Play
            {
                isPlaying = true;
                try
                {
                    MediaElementVideo.Play();
                    if (PlayerStopOrPause != null)
                        PlayerStopOrPause(true, new EventArgs());
                }
                catch (Exception ex) { }

            }
            else//Pause
            {
                isPlaying = false;
                try
                {
                    MediaElementVideo.Pause();
                    if (PlayerStopOrPause != null)
                        PlayerStopOrPause(false, new EventArgs());
                }
                catch (Exception exx) { }
                //ButtonPlayPause.Background = FindResource("[Skin_1]_Play_button_xaml") as Brush;
            }
        }

        private void ButtonFastForward_Click(object sender, RoutedEventArgs e)
        {
            if (MediaElementVideo.SpeedRatio <= 3)
                MediaElementVideo.SpeedRatio += 1;
        }

        private void ButtonFastForward_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (MediaElementVideo.SpeedRatio <= 3)
                MediaElementVideo.SpeedRatio += 1;
        }

        private void ButtonRewind_Click(object sender, RoutedEventArgs e)
        {
            //TimeSpan ts = new TimeSpan(0, 0, 0, 0);
            if (MediaElementVideo.SpeedRatio > 1)
            {
                MediaElementVideo.SpeedRatio -= 1;
            }
            else
            {
                MediaElementVideo.Position = MediaElementVideo.Position.Add(new TimeSpan(0, 0, 0, -5));
            }
        }

        private void ButtonRewind_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {

            //TimeSpan ts = new TimeSpan(0, 0, 0,0);
            if (MediaElementVideo.SpeedRatio > 1)
            {
                MediaElementVideo.SpeedRatio -= 1;
            }
            else
            {
                MediaElementVideo.Position = MediaElementVideo.Position.Add(new TimeSpan(0, 0, 0, -5));
            }
        }

        #endregion

        private void MediaElementVideo_MediaOpened(object sender, RoutedEventArgs e)
        {
            OnPlayerOpened();
        }
        protected virtual void OnPlayerOpened()
        {
            if(PlayerOpened!=null)
                PlayerOpened(this, new EventArgs());
        }

        private void Play_Pause_area_DragEnter(object sender, SurfaceDragDropEventArgs e)
        {
            //Console.WriteLine("Enter");

            // If the TimelineAnnotationView comes from a user control different from the current one, 
            // it means that we want to add the annotation to the current list.
            // So we check if the dragged annotation can be dragged or if it will recover any existant annotation (in this case it will not be accepted)
            // e.Cursor.DragSource is the SurfaceListBox where the drag started from
            SurfaceListBox slb = (SurfaceListBox)e.Cursor.DragSource;
            // We get the instance of the UserControlSyncSource
            UserControl syncSrc = (UserControl)((Grid)((Grid)this.Parent).Parent).Parent;
            // and its UserControlTimeline
            UserControlTimeLine tl = (UserControlTimeLine)((Grid)((Grid)syncSrc.Content).Children[0]).Children[0];
            if (((Grid)((UserControl)((Grid)slb.Parent).Parent).Parent).Parent != tl)
            {
                // e.Cursor.Visual is the ContentControl, so its Content is the dragged TimelineAnnotationView
                AnnotationViewModel annotationDataVM = (AnnotationViewModel)((TimelineAnnotationView)((ContentControl)e.Cursor.Visual).Content).DataContext;
                Play_Pause_area.Background = tl.isAnnotationAccepted(annotationDataVM) ? new SolidColorBrush(Colors.Green) : new SolidColorBrush(Colors.Red);
            }
            else
            {
                Play_Pause_area.Background = new SolidColorBrush(Colors.White);
            }
            Play_Pause_area.Opacity = 0.3;

        }

        private void Play_Pause_area_DragLeave(object sender, SurfaceDragDropEventArgs e)
        {
            //Console.WriteLine("Leave");
            Play_Pause_area.Opacity = 0;
        }

        private void Play_Pause_area_DragOver(object sender, SurfaceDragDropEventArgs e)
        {
            //Console.WriteLine("Over");
        }

        private void Play_Pause_area_Drop(object sender, SurfaceDragDropEventArgs e)
        {
            //Console.WriteLine("Drop");
            Play_Pause_area.Opacity = 0;
            // e.Cursor.Visual is the ContentControl, so its Content is the dragged TimelineAnnotationView
            AnnotationViewModel annotationDataVM = (AnnotationViewModel)((TimelineAnnotationView)((ContentControl)e.Cursor.Visual).Content).DataContext;
            int nbSeconds = (int)annotationDataVM.TcBegin;
            int nbMilliSec = (int)((annotationDataVM.TcBegin * 1000)%1000);
            MediaElementVideo.Position = new TimeSpan(0, 0, 0, nbSeconds, nbMilliSec);


            // If the TimelineAnnotationView comes from a user control different from the current one, 
            // it means that we want to add the annotation to the current list.
            // So we generate the ActionAddAnnotation
            // e.Cursor.DragSource is the SurfaceListBox where the drag started from
            SurfaceListBox slb = (SurfaceListBox)e.Cursor.DragSource;
            // We get the instance of the UserControlSyncSource
            UserControl syncSrc = (UserControl)((Grid)((Grid)this.Parent).Parent).Parent;
            // and its UserControlTimeline
            UserControl tl = (UserControl)((Grid)((Grid)syncSrc.Content).Children[0]).Children[0];
            if (((Grid)((UserControl)((Grid)slb.Parent).Parent).Parent).Parent != tl)
            {
                // Now we build the action arguments : a list holding the timeline and the annotation view models
                List<Object> actionsArgs = new List<Object>();
                actionsArgs.Add(tl);
                actionsArgs.Add(annotationDataVM);

                ActionGenerator ag = new ActionGenerator();
                ActionBase ab = ag.GetAction("ActionAddAnnotation", actionsArgs);
                if (ab != null)
                    ab.Execute();
            }

        }

        //This function Sets a brush in a specific rectangle of the StackPanelAnnotation
        public void displayStackPanelAnnotations(int id, Brush brushAnnotation)
        {
            Object o = null;
            switch (id)
            {
                case 1: 
                    rect1.Fill = brushAnnotation;
                    o = rect1.FindResource("Rect1Annotation");
                    rect1.BeginStoryboard((Storyboard)o);
                    break;
                case 2: rect2.Fill = brushAnnotation;
                    o = rect2.FindResource("Rect2Annotation");
                    rect2.BeginStoryboard((Storyboard)o);
                    break;
                case 3: rect3.Fill = brushAnnotation;
                    o = rect3.FindResource("Rect3Annotation");
                    rect3.BeginStoryboard((Storyboard)o);
                    break;
                case 4: rect4.Fill = brushAnnotation;
                    o = rect4.FindResource("Rect4Annotation");
                    rect4.BeginStoryboard((Storyboard)o);
                    break;
                default: break;
            }
        }
	}
}