using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using Microsoft.Surface;
using Microsoft.Surface.Presentation;
using Microsoft.Surface.Presentation.Controls;

using FingersDance.Control.UserPanel;
using FingersDance.Control.ListVideo;
using FingersDance.Control.SessionInput;
using FingersDance.Control.Screen;


namespace FingersDance
{
    /// <summary>
    /// Interaction logic for SurfaceWindow1.xaml
    /// </summary>
    public partial class SurfaceWindow1 : SurfaceWindow
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        /// 
        #region Variables
        private bool isCreatedP1 = false;
        private bool isCreatedP2 = false;
        private bool isCreatedP3 = false;
        private bool isCreatedP4 = false;
        #endregion

        ActionFactory.ActionGenerator _Factory = new FingersDance.ActionFactory.ActionFactory().GetGenerator();

        public SurfaceWindow1()
        {
            InitializeComponent();

            //Permet d'initialiser l'inertie du Pivot une fois relach.
            InitPivotInertia();
            //Permet d'initialiser les quand Grid  la position initiale du pivot
            InitGridPositions();
            // Add handlers for Application activation events
            AddActivationHandlers();
        }

        private void InitPivotInertia()
        {
            try
            {
                ScatterViewItem item = (ScatterViewItem)scaterview.Items.GetItemAt(0);
                item.DecelerationRate = double.NaN;
            }
            catch (Exception ex) { }
        }

        private void InitGridPositions()
        {
            //Initialise les 4 Grids  la positions initiale du Pivot.   
            try
            {
                ScatterViewItem item = (ScatterViewItem)scaterview.Items.GetItemAt(0);
                Grid1.Width =item.Center.X;
                Grid1.Height = item.Center.Y;
                
                Grid2.Width = item.Center.X;
                Grid2.Height = 768 - item.Center.Y;

                Grid3.Width = 1024 - item.Center.X;
                Grid3.Height = 768 - item.Center.Y;

                Grid4.Width = 1024 - item.Center.X;
                Grid4.Height = item.Center.Y;
            }
            catch (Exception ex) { }
        }


        /// <summary>
        /// Occurs when the window is about to close. 
        /// </summary>
        /// <param name="e"></param>
        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // Remove handlers for Application activation events
            RemoveActivationHandlers();
        }

        /// <summary>
        /// Adds handlers for Application activation events.
        /// </summary>
        private void AddActivationHandlers()
        {
            // Subscribe to surface application activation events
            ApplicationLauncher.ApplicationActivated += OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed += OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated += OnApplicationDeactivated;
        }

        /// <summary>
        /// Removes handlers for Application activation events.
        /// </summary>
        private void RemoveActivationHandlers()
        {
            // Unsubscribe from surface application activation events
            ApplicationLauncher.ApplicationActivated -= OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed -= OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated -= OnApplicationDeactivated;
        }

        /// <summary>
        /// This is called when application has been activated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationActivated(object sender, EventArgs e)
        {
            //TODO: enable audio, animations here
        }

        /// <summary>
        /// This is called when application is in preview mode.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationPreviewed(object sender, EventArgs e)
        {
            //TODO: Disable audio here if it is enabled

            //TODO: optionally enable animations here
        }

        /// <summary>
        ///  This is called when application has been deactivated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationDeactivated(object sender, EventArgs e)
        {
            //TODO: disable audio, animations here
        }

        private void scaterview_ContactChanged(object sender, ContactEventArgs e)
        {
            //Permet la MAJ des 4 Grids  la position du pivot
            /*try
            {
                Grid1.Width = e.GetPosition(mainSurfaceWindow).X;
                Grid1.Height = e.GetPosition(mainSurfaceWindow).Y;

                Grid3.Width = e.GetPosition(mainSurfaceWindow).X;
                Grid3.Height = 768 - e.GetPosition(mainSurfaceWindow).Y;

                Grid4.Width = 1024 - e.GetPosition(mainSurfaceWindow).X;
                Grid4.Height = 768 - e.GetPosition(mainSurfaceWindow).Y;

                Grid2.Width = 1024 - e.GetPosition(mainSurfaceWindow).X;
                Grid2.Height = e.GetPosition(mainSurfaceWindow).Y;
            }
            catch (Exception ex) { }*/
        }

        private void ScatterViewItemPivot_ContactChanged(object sender, ContactEventArgs e)
        {
            //Permet la MAJ des 4 Grids  la position du pivot
            try
            {
                Grid1.Width = e.GetPosition(mainSurfaceWindow).X;
                Grid1.Height = e.GetPosition(mainSurfaceWindow).Y;

                Grid3.Width = e.GetPosition(mainSurfaceWindow).X;
                Grid3.Height = 768 - e.GetPosition(mainSurfaceWindow).Y;

                Grid4.Width = 1024 - e.GetPosition(mainSurfaceWindow).X;
                Grid4.Height = 768 - e.GetPosition(mainSurfaceWindow).Y;

                Grid2.Width = 1024 - e.GetPosition(mainSurfaceWindow).X;
                Grid2.Height = e.GetPosition(mainSurfaceWindow).Y;

                //GRISAGE
                //Grid1
                if (Grid1.Width < (1024 / 4) || Grid2.Height < (768 / 4))
                {
                    try
                    {Grid1.Children[1].Visibility = Visibility.Hidden;}
                    catch (Exception) { }
                }
                else
                {
                    try
                    { Grid1.Children[1].Visibility = Visibility.Visible; }
                    catch (Exception) { }
                }
                //Grid2
                if (Grid2.Width < (1024 / 4) || Grid2.Height < (768 / 4))
                {
                    try
                    { Grid2.Children[1].Visibility = Visibility.Hidden; }
                    catch (Exception) { }
                }
                else
                {
                    try
                    { Grid2.Children[1].Visibility = Visibility.Visible; }
                    catch (Exception) { }
                }
                //Grid3
                if (Grid3.Width < (1024 / 4) || Grid3.Height < (768 / 4))
                {
                    try
                    { Grid3.Children[1].Visibility = Visibility.Hidden; }
                    catch (Exception) { }
                }
                else
                {
                    try
                    { Grid3.Children[1].Visibility = Visibility.Visible; }
                    catch (Exception) { }
                }
                //Grid4
                if (Grid4.Width < (1024 / 4) || Grid4.Height < (768 / 4))
                {
                    try
                    { Grid4.Children[1].Visibility = Visibility.Hidden; }
                    catch (Exception) { }
                }
                else
                {
                    try
                    { Grid4.Children[1].Visibility = Visibility.Visible; }
                    catch (Exception) { }
                }
            }
            catch (Exception) { }
        }

        private void UserControlPivot_EH_SurfaceButtonPlayer1_ContactDown(object sender, EventArgs e)
        {
            
            if (!isCreatedP1)
            {
                //1-Creation du control Screen
                UserControlScreen Screen1 = new UserControlScreen();
                Screen1.Name = "Screen1";
                Screen1.contexteGrid = Grid1.Name.ToString();
                //2-Rajout du screen dans la grid correspondante
                Grid1.Children.Add(Screen1);

                //3-Creation de la ListVideo
                UserControlListVideo ListVideo1 = new UserControlListVideo();
                ListVideo1.Name = "ListVideo1";
                
                //4-Ajout de la ListVideo au ControlScreen
                Screen1.AddToGrid(ListVideo1);

                //5-Creation des Events pour chaque item de la video
                ListVideo1.EH_ItemVideo1_ContactDown += new System.EventHandler(this.ListVideo1_EH_ItemVideo1_ContactDown);
                ListVideo1.EH_ItemVideo2_ContactDown += new System.EventHandler(this.ListVideo1_EH_ItemVideo2_ContactDown);

            }            
        }

        private void UserControlPivot_EH_SurfaceButtonPlayer2_ContactDown(object sender, EventArgs e)
        {
            if (!isCreatedP2)
            {
               /* UserControlUserPanel UserPanel2 = new UserControlUserPanel();
                UserPanel2.Name = "UserPanel2";
                Grid2.Children.Add(UserPanel2);
                isCreatedP2 = true;*/

                //1-Creation du control Screen
                UserControlScreen Screen2 = new UserControlScreen();
                Screen2.Name = "Screen2";
                Screen2.contexteGrid = Grid2.Name.ToString();
                //2-Rajout du screen dans la grid correspondante
                Grid2.Children.Add(Screen2);

                //3-Creation de la ListVideo
                UserControlListVideo ListVideo2 = new UserControlListVideo();
                ListVideo2.Name = "ListVideo2";

                //4-Ajout de la ListVideo au ControlScreen
                Screen2.AddToGrid(ListVideo2);

                //5-Creation des Events pour chaque item de la video
                ListVideo2.EH_ItemVideo1_ContactDown += new System.EventHandler(this.ListVideo1_EH_ItemVideo1_ContactDown);
                ListVideo2.EH_ItemVideo2_ContactDown += new System.EventHandler(this.ListVideo1_EH_ItemVideo2_ContactDown);

            } 
        }

        private void UserControlPivot_EH_SurfaceButtonPlayer3_ContactDown(object sender, EventArgs e)
        {
            if (!isCreatedP3)
            {
                UserControlUserPanel UserPanel3 = new UserControlUserPanel();
                UserPanel3.Name = "UserPanel3";
                Grid3.Children.Add(UserPanel3);
                isCreatedP3 = true;
            } 
        }

        private void UserControlPivot_EH_SurfaceButtonPlayer4_ContactDown(object sender, EventArgs e)
        {
            if (!isCreatedP4)
            {
                UserControlUserPanel UserPanel4 = new UserControlUserPanel();
                UserPanel4.Name = "UserPanel4";
                Grid4.Children.Add(UserPanel4);
                isCreatedP4 = true;
            } 
        }

        private void ListVideo1_EH_ItemVideo1_ContactDown(object sender, EventArgs e)
        {

            //Creation d'un ScatterView Item
            //ScatterViewItem scatterViewItemSessionInput = new ScatterViewItem();
            //scatterViewItemSessionInput.Name = "ScatterViewItemSessionInput";
            
            
            //1-Creation d'une nouvelle seance.                
            UserControlSessionInput SessionInput = new UserControlSessionInput();
            SessionInput.Name = "SessionInput";

            try{
                //2-Recuperer la Grid (Layout root du UC screen)qui contient le UCListVideo et l'ajouter.
                Grid actualGrid = (Grid)(((UserControlListVideo)sender).Parent);
                actualGrid.Children.Add(SessionInput);
                
                //2.5 rensegner la video choisie au screen
                ((UserControlScreen)actualGrid.Parent).Path = ((UserControlListVideo)sender).path;
                //3-Creation des Events
                SessionInput.EH_SurfaceButtonSubmit_ContactDown += new System.EventHandler(this.SessionInput_EH_SurfaceButtonSubmit_ContactDown);
                //4-Supression du UC List Video
                actualGrid.Children.Remove((UserControlListVideo)sender);

                //Init Scatter View Properties and Add it to the scatter view.
                /*scatterViewItemSessionInput.Content = SessionInput;
                scatterViewItemSessionInput.CanMove = true;
                scatterViewItemSessionInput.CanScale = false;
                scatterViewItemSessionInput.CanRotate = true;
                scatterViewItemSessionInput.Center = new Point((double)actualGrid.ActualWidth,(double)actualGrid.ActualHeight);
                scaterview.Items.Add(scatterViewItemSessionInput);*/
            }
            catch (Exception ex) { }
            isCreatedP1 = true;
        }

        private void ListVideo1_EH_ItemVideo2_ContactDown(object sender, EventArgs e)
        {
            //ToDo
        }

        //Button Submit du control SessionInput
        private void SessionInput_EH_SurfaceButtonSubmit_ContactDown(object sender, EventArgs e)
        {
            try
            {
                //1-Recuperation de actualGrid (LayoutRoot du UC Screen)
                Grid actualGrid = (Grid)(((UserControlSessionInput)sender).Parent);
                //2-Suppression UCSession Input
                actualGrid.Children.Remove((UserControlSessionInput)sender);
                //3-Suppression du UC Screen
                Grid root = (Grid) ((UserControlScreen)actualGrid.Parent).Parent;
                root.Children.Remove((UserControlScreen)actualGrid.Parent);
                //4-Creation du User Panel
                UserControlUserPanel UserPanel1 = new UserControlUserPanel();
                UserPanel1.Name = "UserPanel1";
                //5-Rajout sur la Grid Root
                root.Children.Add(UserPanel1);
                
            }
            catch (Exception ex) { }
        }



    }
}