﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;

using FingersDance.Data;

namespace FingersDance.ViewModels
{
    public class AnnotationViewModel : ViewModelBase
    {
        readonly Annotation a;

        private float _marginLeft;
        private Double _scaleX = 1;

        public AnnotationViewModel(Annotation aPar, float marginLeft, Double scaleX)
        {
            a = aPar;

            this._marginLeft = marginLeft;
            this._marginLeft = marginLeft;
            this._scaleX = scaleX;
        }
        public AnnotationViewModel(Annotation aPar, float marginLeft)
        {
            a = aPar;

            this._marginLeft = marginLeft;
        }

        public String Id
        {
            get { return a.Id; }
            set
            {
                if (value == a.Id || String.IsNullOrEmpty(value))
                    return;
                a.Id = value;
                base.OnPropertyChanged("Id");
            }
        }
        public float TcBegin
        {
            get { return a.TcBegin; }
            set
            {
                if (value == a.TcBegin || float.IsNaN(value))
                    return;
                a.TcBegin = value;
                base.OnPropertyChanged("TcBegin");
            }
        }
        public float Dur
        {
            get { return a.Dur; }
            set
            {
                if (value == a.Dur || float.IsNaN(value))
                    return;
                a.Dur = value;
                base.OnPropertyChanged("Dur");
            }
        }
        public List<String> GestureType
        {
            get { return a.GestureType; }
            set
            {
                if (value == a.GestureType)
                    return;
                a.GestureType = value;
                base.OnPropertyChanged("GestureType");
            }
        }
        public Color Color
        {
            get { return a.Color; }
            set
            {
                if (value == a.Color)
                    return;
                a.Color = value;
            }
        }
        public float MarginLeft
        {
            get { return _marginLeft; }
            set
            {
                if (value == _marginLeft || float.IsNaN(value))
                    return;
                _marginLeft = value;
                base.OnPropertyChanged("MarginLeft");
            }
        }
        public Double ScaleX
        {
            get { return _scaleX; }
            set
            {
                if (value == _scaleX || Double.IsNaN(value))
                    return;
                _scaleX = value;
                base.OnPropertyChanged("ScaleX");
            }
        }

    }
}
