﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Data;

namespace FingersDance.Control.SessionInput
{
	public partial class UserControlSessionInput
	{
        public event EventHandler EH_SurfaceButtonSubmit_ContactDown;
        public User User = new User();

		public UserControlSessionInput()
		{
			this.InitializeComponent();
            ST_Date.Text = DateTime.Now.Day.ToString() + "/" + DateTime.Now.Month.ToString() + "/" + DateTime.Now.Year.ToString();
		}

        private void SurfaceButtonSubmit_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (!ST_Alias.Text.Equals("") && !ST_Date.Text.Equals("") && !ST_Email.Text.Equals("") && !ST_Name.Text.Equals(""))
            {
                User = new User(ST_Name.Text, ST_Email.Text, ST_Alias.Text);
                if (EH_SurfaceButtonSubmit_ContactDown != null)
                    EH_SurfaceButtonSubmit_ContactDown(this, new EventArgs());
            }
        }

        private void SurfaceButtonSubmit_Click(object sender, RoutedEventArgs e)
        {
            if (!ST_Alias.Text.Equals("") && !ST_Date.Text.Equals("") && !ST_Email.Text.Equals("") && !ST_Name.Text.Equals(""))
            {
                User = new User(ST_Name.Text, ST_Email.Text, ST_Alias.Text);
                if (EH_SurfaceButtonSubmit_ContactDown != null)
                    EH_SurfaceButtonSubmit_ContactDown(this, new EventArgs());
            }
        }

	}
}