﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Control.ListVideo;
using FingersDance.Control.SessionInput;
using FingersDance.ViewModels;
using FingersDance.Data;

namespace FingersDance.Control.Screen
{
	public partial class UserControlScreen
	{
        public String contexteGrid;
        public int id = 0;
        public event EventHandler UC_Screen_NewSession;
        public MainViewModel MainViewModel;
        public User User = new User();

        public UserControlScreen(int id, MainViewModel mvmodel)
        {
            this.InitializeComponent();
            this.id = id;
            MainViewModel = mvmodel;

            if (MainViewModel.Session.VideoPath.Equals(""))
            {
                //1-Creation de la ListVideo
                UserControlListVideo ListVideo = new UserControlListVideo();
                ListVideo.Name = "ListVideo1";

                //2-Ajout de la ListVideo au ControlScreen
                this.AddToGrid(ListVideo);

                //3-Creation des Events pour chaque item de la video
                ListVideo.EH_ItemVideo1_ContactDown += new System.EventHandler(this.ListVideo_EH_ItemVideo_ContactDown);
            }
            else
                ListVideo_EH_ItemVideo_ContactDown(null, null);
        }

        //Rajout un UIElement vers la grid du screen.
        public void AddToGrid(UIElement uie)
        {
            if (uie != null)
            {
                try { LayoutRoot.Children.Add(uie); }
                catch(Exception){}
            }          
        }

        private void ListVideo_EH_ItemVideo_ContactDown(object sender, EventArgs e)
        {
            //1-Creation d'une nouvelle seance.                
            UserControlSessionInput SessionInput = new UserControlSessionInput();
            SessionInput.Name = "SessionInput";

            try
            {
                //2-Recuperer la Grid (Layout root du UC screen)qui contient le UCListVideo et l'ajouter.
                
                LayoutRoot.Children.Add(SessionInput);

                //2.5 rensegner la video choisie au screen
                if (sender != null)
                    MainViewModel.CreateSession(((UserControlListVideo)sender).VideoName, ((UserControlListVideo)sender).path);

                //3-Creation des Events
                SessionInput.EH_SurfaceButtonSubmit_ContactDown += new System.EventHandler(this.SessionInput_EH_SurfaceButtonSubmit_ContactDown);
                //4-Supression du UC List Video
                LayoutRoot.Children.Remove((UserControlListVideo)sender);
            }
            catch (Exception ex) { }
        }
        
        private void SessionInput_EH_SurfaceButtonSubmit_ContactDown(object sender, EventArgs e)
        {
            try
            {
                //1-Creation du projet
                User = ((UserControlSessionInput)sender).User;
                MainViewModel.CreateProject(User);
                //2-Suppression UCSession Input
                LayoutRoot.Children.Remove((UserControlSessionInput)sender);
                //3-Suppression du UC Screen
                if(UC_Screen_NewSession!=null)
                    UC_Screen_NewSession(this, new EventArgs());
            }
            catch (Exception ex) { }
        }
	}
}