﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Data;

namespace FingersDance.Control.SessionInput
{
    /// <summary>
    /// Interaction logic for UserControlNewProjectForm.xaml
    /// </summary>
    public partial class UserControlNewProjectForm : UserControl
    {
        public event EventHandler EH_NewProjectForm_ContactDown;
        public string ProjectName = "";
        public string Email = "";
        public string Alias = "";
        public string Description = "";

		public UserControlNewProjectForm()
		{
			this.InitializeComponent();
            ST_Date.Text = DateTime.Now.Day.ToString() + "/" + DateTime.Now.Month.ToString() + "/" + DateTime.Now.Year.ToString();
        }

        #region Actions

        private void SurfaceButtonSubmit_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            //if (!ST_Alias.Text.Equals("") && !ST_Date.Text.Equals("") && !ST_Email.Text.Equals("") && !ST_Name.Text.Equals(""))
            if (!ST_Name.Text.Equals(""))
            {
                ProjectName = ST_Name.Text;
                Email= ST_Email.Text;
                Alias = ST_Alias.Text;
                Description = ST_Desc.Text;
                if (EH_NewProjectForm_ContactDown != null)
                    EH_NewProjectForm_ContactDown(this, new EventArgs());
            }
        }

        private void SurfaceButtonSubmit_Click(object sender, RoutedEventArgs e)
        {
            //if (!ST_Alias.Text.Equals("") && !ST_Date.Text.Equals("") && !ST_Email.Text.Equals("") && !ST_Name.Text.Equals(""))
            if (!ST_Name.Text.Equals(""))
            {
                ProjectName = ST_Name.Text;
                Email = ST_Email.Text;
                Alias = ST_Alias.Text;
                Description = ST_Desc.Text;
                if (EH_NewProjectForm_ContactDown != null)
                    EH_NewProjectForm_ContactDown(this, new EventArgs());
            }
        }

        #endregion
    }
}
