using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using Microsoft.Surface;
using Microsoft.Surface.Presentation;
using Microsoft.Surface.Presentation.Controls;

namespace FingersDance
{
    /// <summary>
    /// Interaction logic for SurfaceWindow1.xaml
    /// </summary>
    public partial class SurfaceWindow1 : SurfaceWindow
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        /// 

        ActionFactory.ActionGenerator _Factory = new FingersDance.ActionFactory.ActionFactory().GetGenerator();

        public SurfaceWindow1()
        {
            InitializeComponent();

            //Permet d'initialiser les quand Grid  la position initiale du pivot
            InitGridPositions();
            // Add handlers for Application activation events
            AddActivationHandlers();
        }

        private void InitGridPositions()
        {
            //Initialise les 4 Grids  la positions initiale du Pivot.   
            try
            {
                ScatterViewItem item = (ScatterViewItem)ScaterView.Items.GetItemAt(0);
                Grid1.Width =item.Center.X;
                Grid1.Height = item.Center.Y;
                
                Grid2.Width = item.Center.X;
                Grid2.Height = 768 - item.Center.Y;

                Grid3.Width = 1024 - item.Center.X;
                Grid3.Height = 768 - item.Center.Y;

                Grid4.Width = 1024 - item.Center.X;
                Grid4.Height = item.Center.Y;
            }
            catch (Exception ex) { }
        }


        /// <summary>
        /// Occurs when the window is about to close. 
        /// </summary>
        /// <param name="e"></param>
        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // Remove handlers for Application activation events
            RemoveActivationHandlers();
        }

        /// <summary>
        /// Adds handlers for Application activation events.
        /// </summary>
        private void AddActivationHandlers()
        {
            // Subscribe to surface application activation events
            ApplicationLauncher.ApplicationActivated += OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed += OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated += OnApplicationDeactivated;
        }

        /// <summary>
        /// Removes handlers for Application activation events.
        /// </summary>
        private void RemoveActivationHandlers()
        {
            // Unsubscribe from surface application activation events
            ApplicationLauncher.ApplicationActivated -= OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed -= OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated -= OnApplicationDeactivated;
        }

        /// <summary>
        /// This is called when application has been activated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationActivated(object sender, EventArgs e)
        {
            //TODO: enable audio, animations here
        }

        /// <summary>
        /// This is called when application is in preview mode.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationPreviewed(object sender, EventArgs e)
        {
            //TODO: Disable audio here if it is enabled

            //TODO: optionally enable animations here
        }

        /// <summary>
        ///  This is called when application has been deactivated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationDeactivated(object sender, EventArgs e)
        {
            //TODO: disable audio, animations here
        }

        private void ScaterView_ContactChanged(object sender, ContactEventArgs e)
        {
            //Permet la MAJ des 4 Grids  la position du pivot
            try
            {
                Grid1.Width = e.GetPosition(mainSurfaceWindow).X;
                Grid1.Height = e.GetPosition(mainSurfaceWindow).Y;

                Grid2.Width = e.GetPosition(mainSurfaceWindow).X;
                Grid2.Height = 768 - e.GetPosition(mainSurfaceWindow).Y;

                Grid3.Width = 1024 - e.GetPosition(mainSurfaceWindow).X;
                Grid3.Height = 768 - e.GetPosition(mainSurfaceWindow).Y;

                Grid4.Width = 1024 - e.GetPosition(mainSurfaceWindow).X;
                Grid4.Height = e.GetPosition(mainSurfaceWindow).Y;
            }
            catch (Exception ex) { }
        }
    }
}