﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FingersDance.Data;

namespace FingersDance.ViewModels
{
    public class ProjectViewModel : ViewModelBase
    {
        readonly Project project = new Project();

        #region Constructor

        public ProjectViewModel() { }

        public ProjectViewModel(Project p)
        {
            project = p;
        }

        #endregion

        #region Properties

        public Project Project
        {
            get { return project; }
        }

        public string Date
        {
            get { return project.Date; }
            set { project.Date = value; }
        }

        public string Name
        {
            get { return project.Name; }
            set { project.Name = value; }
        }

        public string Description
        {
            get { return project.Description; }
            set { project.Description = value; }
        }

        public User User
        {
            get { return project.User; }
            set { project.User = value; }
        }

        public Cutting Cutting
        {
            get { return project.Cutting; }
            set { project.Cutting = value; }
        }

        #endregion
    }
}
