﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using FingersDance.Data;
using FingersDance.Control;

namespace FingersDance.Control.SessionInput
{
    /// <summary>
    /// Interaction logic for UserControlListProject.xaml
    /// </summary>
    public partial class UserControlListProject
    {
        //Creation d'un Event pour Chaque Item Video
        public event EventHandler EH_Item_ContactDown;
        public string SelectedItem = "";

        public UserControlListProject(Dictionary<string, Project> projects)
        {
            InitializeComponent();
            OpenSessions(projects);
        }

        private void OpenSessions(Dictionary<string, Project> projects)
        {
            try
            {
                CustomListBoxItem Contener = new CustomListBoxItem();
                Contener.Name = "New Project";
                UserControlCustomLabel l = new UserControlCustomLabel("New Project");
                Contener.Content = l;
                stackPanel.Children.Add(Contener);
                Contener.ContactTapGesture += Item_ContactTapGesture;
                foreach (KeyValuePair<string, Project> elt in projects)
                {
                    Contener = new CustomListBoxItem();
                    Contener.Name = elt.Key;
                    l = new UserControlCustomLabel(elt.Key);
                    Contener.Content = l;
                    stackPanel.Children.Add(Contener);
                    Contener.ContactTapGesture += Item_ContactTapGesture;
                }
            }
            catch (Exception) { }
        }

        //Event appelé lors de la selection d'un Item dans la Liste
        private void Item_ContactTapGesture(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            SelectedItem = ((CustomListBoxItem)sender).Name;
            if (EH_Item_ContactDown != null)
                EH_Item_ContactDown(this, new EventArgs());
        }
    }
}
