﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Data;

namespace FingersDance.Control.SessionInput
{
	public partial class UserControlSessionInput
	{
        public event EventHandler EH_SurfaceButtonSubmit_ContactDown;
        public string Name = "";
        public string Email = "";
        public string Alias = "";
        public string Description = "";

		public UserControlSessionInput()
		{
			this.InitializeComponent();
            ST_Date.Text = DateTime.Now.Day.ToString() + "/" + DateTime.Now.Month.ToString() + "/" + DateTime.Now.Year.ToString();
        }

        #region Actions

        private void SurfaceButtonSubmit_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (!ST_Alias.Text.Equals("") && !ST_Date.Text.Equals("") && !ST_Email.Text.Equals("") && !ST_Name.Text.Equals(""))
            {
                Name= ST_Name.Text;
                Email= ST_Email.Text;
                Alias = ST_Alias.Text;
                Description = ST_Desc.Text;
                if (EH_SurfaceButtonSubmit_ContactDown != null)
                    EH_SurfaceButtonSubmit_ContactDown(this, new EventArgs());
            }
        }

        private void SurfaceButtonSubmit_Click(object sender, RoutedEventArgs e)
        {
            if (!ST_Alias.Text.Equals("") && !ST_Date.Text.Equals("") && !ST_Email.Text.Equals("") && !ST_Name.Text.Equals(""))
            {
                Name = ST_Name.Text;
                Email = ST_Email.Text;
                Alias = ST_Alias.Text;
                Description = ST_Desc.Text;
                if (EH_SurfaceButtonSubmit_ContactDown != null)
                    EH_SurfaceButtonSubmit_ContactDown(this, new EventArgs());
            }
        }

        #endregion

	}
}